<?php

namespace App\Http\Controllers;

use App\Models\AvanceModulos;
use Illuminate\Http\Request;

class AvanceModulosController extends Controller
{
    public function crearAvanceModulos(Request $request) {
        $avance = AvanceModulos::on('costos_principal');

        $id = $avance->create(
            [
                "con_fk_id" => $request->input("con_fk_id"),
                "ins_fk_id" => $request->input("ins_fk_id"),
                "avm_ano" => $request->input("avm_ano"),
                "avm_mes" => $request->input("avm_mes")
            ]
        );

        return array("response" => $id->act_pk_id);
    }

    public function getAvanceModulos(Request $request) {
        if ($request->input('avm_ano') == null) {
            return AvanceModulos::on('costos_principal')
                                ->where('con_fk_id', $request->input('con_fk_id'))
                                ->where('ins_fk_id', $request->input('ins_fk_id'))
                                ->where('avm_ano', $request->input('avm_ano'))
                                ->whereNull('avm_ano')
                                ->get()->toArray();
        } else if ($request->input('avm_mes') == null) {
            return AvanceModulos::on('costos_principal')
                                ->where('con_fk_id', $request->input('con_fk_id'))
                                ->where('ins_fk_id', $request->input('ins_fk_id'))
                                ->where('avm_ano', $request->input('avm_ano'))
                                ->whereNull('avm_mes')
                                ->get()->toArray();
        } else {
            return AvanceModulos::on('costos_principal')
                                ->where('con_fk_id', $request->input('con_fk_id'))
                                ->where('ins_fk_id', $request->input('ins_fk_id'))
                                ->where('avm_ano', $request->input('avm_ano'))
                                ->where('avm_mes', $request->input('avm_mes'))
                                ->get()->toArray();
        }
    }

    public function notificarAvance(Request $request) {
        AvanceModulos::on('costos_principal')
                     ->where('con_fk_id', $request->input('con_fk_id'))
                     ->where('ins_fk_id', $request->input('ins_fk_id'))
                     ->where('avm_ano', $request->input('avm_ano'))
                     ->where('avm_mes', $request->input('avm_mes'))
        ->update(
            [
                $request->input('modulo') => true
            ]
        );
    }

    public function cancelarAvance(Request $request) {
        AvanceModulos::on('costos_principal')
                     ->where('con_fk_id', $request->input('con_fk_id'))
                     ->where('ins_fk_id', $request->input('ins_fk_id'))
                     ->where('avm_ano', $request->input('avm_ano'))
                     ->where('avm_mes', $request->input('avm_mes'))
        ->update(
            [
                $request->input('modulo') => false
            ]
        );
    }
}
