<?php

namespace App\Http\Controllers;

use App\Models\Contrato;
use App\Models\HistorialContrato;

use Illuminate\Http\Request;

class ContratoController extends Controller
{
    private $apiKey;

    function __construct() {
        $apiController = new ApiController();
        $this->apiKey = $apiController->getApiKey()["key"];
    }

    public function crearContrato(Request $request) {
        $con_id_contrato = $request->input("con_id_contrato");
        $con_no_usuarios = $request->input("con_no_usuarios");
        $con_nit = $request->input("con_nit");
        $con_razon_social = $request->input("con_razon_social");
        $con_rep_legal = $request->input("con_rep_legal");
        $con_correo_rep = $request->input("con_correo_rep");
        $con_direccion = $request->input("con_direccion");
        $dep_fk_id = $request->input("dep_fk_id");
        $con_ciudad = $request->input("con_ciudad");
        $con_fecha_inicio = $request->input("con_fecha_inicio");
        $con_fecha_fin = $request->input("con_fecha_fin");
        $con_fecha_inicio_carga = $request->input("con_fecha_inicio_carga");
        $con_fecha_fin_carga = $request->input("con_fecha_fin_carga");

        $contrato = Contrato::on('costos_principal');

        $id = $contrato->create(
            [
                "con_id_contrato" => $con_id_contrato,
                "con_no_usuarios" => $con_no_usuarios,
                "con_nit" => $con_nit,
                "con_razon_social" => $con_razon_social,
                "con_rep_legal" => $con_rep_legal,
                "con_correo_rep" => $con_correo_rep,
                "con_direccion" => $con_direccion,
                "dep_fk_id" => $dep_fk_id,
                "con_ciudad" => $con_ciudad,
                "con_fecha_inicio" => $con_fecha_inicio,
                "con_fecha_fin" => $con_fecha_fin,
                "con_fecha_inicio_carga" => $con_fecha_inicio_carga,
                "con_fecha_fin_carga" => $con_fecha_fin_carga
            ]
        );

        // Retornar el id en db del contrato
        return array("response" => $id->con_pk_id);
    }

    public function getContrato(Request $request) {
        $numero = $request->input("numero");

        // Retornar el tamizaje
        return json_encode(Contrato::on('costos_principal')
                                   ->where('con_pk_id', $numero)->get()->toArray());
    }

    public function getListaContratos(Request $request) {
        return json_encode(Contrato::on('costos_principal')
                                   ->orderBy('con_id_contrato', 'ASC')->get()->toArray());
    }

    public function getListaContratosPorFecha(Request $request) {
        return json_encode(Contrato::on('costos_principal')
                                   ->orderBy('con_fecha_fin', 'DESC')->get()->toArray());
    }

    public function actualizarContrato(Request $request) {
        $con_id_contrato = $request->input("con_id_contrato");
        $con_no_usuarios = $request->input("con_no_usuarios");
        $con_nit = $request->input("con_nit");
        $con_razon_social = $request->input("con_razon_social");
        $con_rep_legal = $request->input("con_rep_legal");
        $con_correo_rep = $request->input("con_correo_rep");
        $con_direccion = $request->input("con_direccion");
        $dep_fk_id = $request->input("dep_fk_id");
        $con_ciudad = $request->input("con_ciudad");
        $con_fecha_inicio = $request->input("con_fecha_inicio");
        $con_fecha_fin = $request->input("con_fecha_fin");
        $con_fecha_inicio_carga = $request->input("con_fecha_inicio_carga");
        $con_fecha_fin_carga = $request->input("con_fecha_fin_carga");

        // Historial del contrato
        $contratoActual = Contrato::on('costos_principal')->where('con_pk_id', $request->input("con_pk_id"))->get()->toArray()[0];
        $histContrato = HistorialContrato::on('costos_principal');

        $histContrato->create(
            [
                "hco_id_contrato" => $contratoActual['con_id_contrato'],
                "hco_no_usuarios" => $contratoActual['con_no_usuarios'],
                "hco_nit" => $contratoActual['con_nit'],
                "hco_razon_social" => $contratoActual['con_razon_social'],
                "hco_rep_legal" => $contratoActual['con_rep_legal'],
                "hco_correo_rep" => $contratoActual['con_correo_rep'],
                "hco_direccion" => $contratoActual['con_direccion'],
                "dep_fk_id" => $contratoActual['dep_fk_id'],
                "hco_ciudad" => $contratoActual['con_ciudad'],
                "hco_fecha_inicio" => $contratoActual['con_fecha_inicio'],
                "hco_fecha_fin" => $contratoActual['con_fecha_fin'],
                "hco_fecha_inicio_carga" => $contratoActual['con_fecha_inicio_carga'],
                "hco_fecha_fin_carga" => $contratoActual['con_fecha_fin_carga']
            ]
        );

        // actualización del contrato
        Contrato::on('costos_principal')
                ->where('con_pk_id',$request->input("con_pk_id"))
                ->update(
                    [
                        "con_id_contrato" => $con_id_contrato,
                        "con_no_usuarios" => $con_no_usuarios,
                        "con_nit" => $con_nit,
                        "con_razon_social" => $con_razon_social,
                        "con_rep_legal" => $con_rep_legal,
                        "con_correo_rep" => $con_correo_rep,
                        "con_direccion" => $con_direccion,
                        "dep_fk_id" => $dep_fk_id,
                        "con_ciudad" => $con_ciudad,
                        "con_fecha_inicio" => $con_fecha_inicio,
                        "con_fecha_fin" => $con_fecha_fin,
                        "con_fecha_inicio_carga" => $con_fecha_inicio_carga,
                        "con_fecha_fin_carga" => $con_fecha_fin_carga
                    ]
                );

        return array("response" => 0);
    }

    public function getLogoInstitucion(Request $request) {
        $con_fk_id = $request->input('con_fk_id');

        $logo = Contrato::on('costos_principal')
                        ->where('con_pk_id', $con_fk_id)
                        ->value('con_logo');

        $imagen = null;

        if ($logo != "") {
            $imagen = utf8_encode(\Storage::get('logos/'.$logo));
        }

        return array("response" => $imagen);
    }

    public function actualizarLogoInstitucion(Request $request) {
        $apiKey = $request->apiKey;

        if ($apiKey === $this->apiKey) {
            $con_fk_id = $request->con_fk_id;
            $logo = file_get_contents($request->soporte->path());

            \Storage::put('logos/logo_'.$con_fk_id.'.png', $logo);

            Contrato::on('costos_principal')->where('con_pk_id', $con_fk_id)
            ->update(
                [
                    "con_logo" => 'logo_'.$con_fk_id.'.png'
                ]
            );      
        } else {
            throw new \Exception('Imposible completar la petición.');
        }
    }

    public function verificarExistenciaId(Request $request) {
        $resp = Contrato::on('costos_principal')
                        ->where('con_id_contrato', $request->input('id_contrato'))
                        ->count();

        return array("response" => $resp);
    }
}
