<?php

namespace App\Http\Controllers;

use App\Mail\InfoNuevoUsuario;
use App\Mail\InfoNuevoUsuario2;
use App\Mail\RecuperacionContrasena;

use Illuminate\Support\Facades\Mail;

use App\Http\Controllers\CostosController;

use Illuminate\Http\Request;

class CorreoController extends Controller
{
    public function enviarInformacionUsuario(Request $request) {
        $costos = new CostosController();

        $correo = $request->input("correo");
        $rol = $request->input("rol");
        $nombre = $request->input("nombre");
        $usuario = $request->input("usuario");
        $contrasena = $request->input("contrasena");
        $contrato = $request->input("contrato");

        \Mail::to($correo)->send(new InfoNuevoUsuario($costos->getUrlAplicativo(),
                                                     $rol,
                                                     $nombre,
                                                     $usuario,
                                                     $contrasena,
                                                     $contrato));
    }

    public function enviarInformacionUsuario2(Request $request) {
        $costos = new CostosController();

        $correo = $request->input("correo");
        $rol = $request->input("rol");
        $nombre = $request->input("nombre");
        $usuario = $request->input("usuario");
        $contrasena = $request->input("contrasena");

        \Mail::to($correo)->send(new InfoNuevoUsuario2($costos->getUrlAplicativo(),
                                                      $rol,
                                                      $nombre,
                                                      $usuario,
                                                      $contrasena));
    }

    public function enviarContrasena($correo, $contrasena) {
        \Mail::to($correo)->send(new RecuperacionContrasena($contrasena));
    }
}
