<?php

namespace App\Http\Controllers;

use App\Models\CostoDistribuido;
use App\Models\CostoTotal;
use App\Models\CostosIngresos;
use Illuminate\Http\Request;

class CostoDistribuidoController extends Controller
{
    public function consolidarCostoDistribuido(Request $request) {
        $contrato = $request->input('con_fk_id');
        $institucion = $request->input('ins_fk_id');
        $ano = $request->input('cod_ano');
        $mes = $request->input('cod_mes');

        // Respuesta hacia el usuario
        $response = new \stdClass();
        $response->estado = 1;
        $response->erroresCp = "";
        $response->erroresBd = "";

        \DB::transaction(function() use($contrato, $institucion, $ano, $mes, $response) {
            $revision = $this->verificarEstadoDistribucion($contrato, $institucion, $ano, $mes);

            if (count($revision->basesDistribucion) === 0) {
                // Borrar la informacion consolidada previamente
                CostoDistribuido::on('costos_principal')
                                ->where('con_fk_id', $contrato)
                                ->where('ins_fk_id', $institucion)
                                ->where('cod_ano', $ano)
                                ->where('cod_mes', $mes)
                                ->delete();

                CostoTotal::on('costos_principal')
                          ->where('con_fk_id', $contrato)
                          ->where('ins_fk_id', $institucion)
                          ->where('cot_ano', $ano)
                          ->where('cot_mes', $mes)
                          ->delete();

                CostosIngresos::on('costos_principal')
                              ->where('con_fk_id', $contrato)
                              ->where('ins_fk_id', $institucion)
                              ->where('coi_ano', $ano)
                              ->where('coi_mes', $mes)
                              ->delete();

                // Consolidar el costo distribuido
                \DB::select("
                    insert into costos_principal.costo_distribuido (con_fk_id, ins_fk_id, cod_ano, cod_mes, cod_cco_no_final,
                                                                    cod_costo_primario, cod_cco_final, cod_costo_fijo_dist,
                                                                    cod_costo_variable_dist, cod_costo_directo_dist,
                                                                    cod_costo_indirecto_dist, cod_costo_dist_total)
                    select ".$contrato.",
                           '".$institucion."',
                           ".$ano.",
                           ".$mes.",
                           s2.no_final as cco_no_final,
                           s2.cpr_total as costo_primario,
                           s2.dco_centro_final as cco_final,
                           sum(s2.cpr_costos_directos * s2.dcb_ponderacion * s2.ponderacion_bd) as costo_directo_dist_total,
                           sum(s2.cpr_costos_indirectos * s2.dcb_ponderacion * s2.ponderacion_bd) as costo_indirecto_dist_total,
                           sum(s2.cpr_costos_fijos * s2.dcb_ponderacion * s2.ponderacion_bd) as costo_fijo_dist_total,
                           sum(s2.cpr_costos_variables * s2.dcb_ponderacion * s2.ponderacion_bd) as costo_variable_dist_total,
                           sum(s2.cpr_total * s2.dcb_ponderacion * s2.ponderacion_bd) as costo_distribuido_total
                    from (
                        select s1.*,
                            (s1.ibd2_valor / valor_base_dist) as ponderacion_bd
                        from (
                            select cp.cco_fk_id as no_final,
                                   dcc.dco_centro_final,
                                   dcb.bdi_fk_id,
                                   ibd2_valor,
                                   sum(ibd.ibd2_valor) over (partition by cp.cco_fk_id, dcb.bdi_fk_id order by dcb.bdi_fk_id) as valor_base_dist,
                                   dcb.dcb_ponderacion / 100 as dcb_ponderacion,
                                   cpr_costos_directos,
                                   cpr_costos_indirectos,
                                   cpr_costos_fijos,
                                   cpr_costos_variables,
                                   cpr_total
                            from costos_principal.costo_primario as cp
                            join costos_principal.centros_costo as cco on (cp.cco_fk_id = cco.cco_pk_id and cco.cco_final = false)
                            join costos_principal.distribucion_costos_centros as dcc on (cp.cco_fk_id = dcc.dco_centro_no_final)
                            join costos_principal.distribucion_costos_bases as dcb on (dcc.dco_centro_no_final = dcb.cco_fk_id and dcb.bdi_fk_id not in (1,2))
                            join costos_principal.informacion_bases_distribucion2 as ibd on (ibd.ibd2_ano = ".$ano." and ibd.ibd2_mes = ".$mes." and
                                                                                             ibd.con_fk_id = ".$contrato." and ibd.ins_fk_id = '".$institucion."' and
                                                                                             ibd.cco_fk_id = dcc.dco_centro_final and ibd.bdi_fk_id = dcb.bdi_fk_id)
                            where cp.con_fk_id = ".$contrato." and cp.ins_fk_id = '".$institucion."' and cpr_ano = ".$ano." and cpr_mes = ".$mes."
                            order by no_final, dco_centro_final, bdi_fk_id
                        ) as s1
                    ) as s2
                    group by 1, 2, 3, 4, 5, 6, 7
                ");

                /*\DB::select("insert into costos_principal.costo_distribuido (con_fk_id, ins_fk_id, cod_ano, cod_mes, cod_cco_no_final,
                                                                             cod_costo_primario, cod_cco_final, cod_costo_fijo_dist,
                                                                             cod_costo_variable_dist, cod_costo_directo_dist,
                                                                             cod_costo_indirecto_dist, cod_costo_dist_total)
                            select ".$contrato.",
                                   '".$institucion."',
                                   ".$ano.",
                                   ".$mes.",
                                   no_final as cco_no_final,
                                   cpr_total as costo_primario,
                                   dco_centro_final as cco_final,
                                   sum(cd.cpr_costos_directos * cd.dcb_ponderacion * cd.ponderacion_bd) as costo_directo_dist_total,
                                   sum(cd.cpr_costos_indirectos * cd.dcb_ponderacion * cd.ponderacion_bd) as costo_indirecto_dist_total,
                                   sum(cd.cpr_costos_fijos * cd.dcb_ponderacion * cd.ponderacion_bd) as costo_fijo_dist_total,
                                   sum(cd.cpr_costos_variables * cd.dcb_ponderacion * cd.ponderacion_bd) as costo_variable_dist_total,
                                   sum(cd.cpr_total * cd.dcb_ponderacion * cd.ponderacion_bd) as costo_distribuido_total
                            from (
                                select cp.cco_fk_id as no_final,
                                       dcc.dco_centro_final,
                                       dcb.bdi_fk_id,
                                       dcb.dcb_ponderacion / 100 as dcb_ponderacion,
                                       ibd2_valor,
                                       ibd2_valor / cast((
                                            select sum(ibd2_valor)
                                            from costos_principal.informacion_bases_distribucion2
                                            where con_fk_id = ".$contrato." and
                                                ins_fk_id = '".$institucion."' and 
                                                ibd2_ano = ".$ano." and
                                                ibd2_mes = ".$mes." and
                                                bdi_fk_id = dcb.bdi_fk_id and
                                                cco_fk_id in (
                                                    select dco_centro_final
                                                    from costos_principal.distribucion_costos_centros
                                                    where con_fk_id = ".$contrato." and
                                                          ins_fk_id = '".$institucion."' and
                                                          dco_ano = ".$ano." and
                                                          dco_centro_no_final = cp.cco_fk_id
                                                )
                                       ) as double precision) as ponderacion_bd,
                                       cpr_costos_directos,
                                       cpr_costos_indirectos,
                                       cpr_costos_fijos,
                                       cpr_costos_variables,
                                       cpr_total
                                from costos_principal.costo_primario as cp
                                join costos_principal.centros_costo as cco on (cp.cco_fk_id = cco.cco_pk_id)
                                join costos_principal.distribucion_costos_centros as dcc on (cp.cco_fk_id = dcc.dco_centro_no_final)
                                join costos_principal.distribucion_costos_bases as dcb on (dcc.dco_centro_no_final = dcb.cco_fk_id)
                                join costos_principal.informacion_bases_distribucion2 as ifm on (ifm.bdi_fk_id = dcb.bdi_fk_id and
                                                                                                ifm.cco_fk_id = dcc.dco_centro_final and
                                                                                                ifm.ibd2_ano = ".$ano." and
                                                                                                ifm.ibd2_mes = ".$mes.")
                                where cp.con_fk_id = ".$contrato." and
                                      cp.ins_fk_id = '".$institucion."' and
                                      cpr_ano = ".$ano." and
                                      cpr_mes = ".$mes." and
                                      cco.cco_final = false and
                                      dcb.bdi_fk_id not in (1,2)
                            ) as cd
                            group by 1, 2, 3, 4, 5, 6, 7");*/

                // Agregar distribuciones por partes iguales y valor directo
                $this->agregarDistribucionPartesIguales($contrato, $institucion, $ano, $mes);

                // Consolidar el costo total
                $this->consolidarCostoTotal($contrato, $institucion, $ano, $mes);

                // Consolidar indicador costos ingresos
                $this->consolidarCostosIngresos($contrato, $institucion, $ano, $mes);
            } else {
                $response->estado = 0;
                $response->erroresBd = json_encode($revision->basesDistribucion);
            }
        });

        return array("response" => json_encode($response));
    }

    // Mirar si todas los movimientos tienen al menos un centro de costo asignado por base de distribucion
    private function verificarEstadoDistribucion($contrato, $institucion, $ano, $mes) {
        $response = new \stdClass();

        // Las bases de distribucion deben tener valor en al menos un centro final
        $basesDistribucion = \DB::select("select err2.sed_nombre_sede as sede,
                                                 concat(err2.sed_nombre_sede, ' - ', err2.cco_descripcion) as cco_no_final,
                                                 bdi.bdi_descripcion
                                          from (
                                                select sed.sed_nombre_sede, cco.cco_descripcion, dcc.dco_centro_final, dcb.bdi_fk_id, ibd.ibd2_valor
                                                from costos_principal.distribucion_costos_centros as dcc
                                                join costos_principal.centros_costo as cco on (cco.cco_pk_id = dcc.dco_centro_no_final)
                                                join costos_principal.sedes as sed on (sed.sed_pk_id = cco.sed_fk_id)
                                                join costos_principal.distribucion_costos_bases as dcb on (dcc.dco_centro_no_final = dcb.cco_fk_id)
                                                left join costos_principal.informacion_bases_distribucion2 as ibd on (dcb.bdi_fk_id = ibd.bdi_fk_id and
                                                                                                                      dcc.dco_centro_final = ibd.cco_fk_id and
                                                                                                                      ibd.ibd2_ano = ".$ano." and ibd.ibd2_mes = ".$mes.")
                                                where dcc.con_fk_id = ".$contrato." and
                                                      dcc.ins_fk_id = '".$institucion."' and
                                                      dcc.dco_ano = ".$ano." and
                                                      dcb.bdi_fk_id != 2
                                          ) as err2
                                          join costos_principal.centros_costo as cco on (err2.dco_centro_final = cco.cco_pk_id)
                                          join costos_principal.bases_distribucion as bdi on (err2.bdi_fk_id = bdi.bdi_pk_id)
                                          group by 1,2,3
                                          having count(*) = count(*) filter (where err2.ibd2_valor is null)");

        $response->basesDistribucion = $basesDistribucion;

        return $response;
    }

    public function getCostoDistribuido(Request $request) {
        return CostoDistribuido::on('costos_principal')
                               ->where('con_fk_id', $request->input('con_fk_id'))
                               ->where('ins_fk_id', $request->input('ins_fk_id'))
                               ->where('cod_ano', $request->input('cod_ano'))
                               ->where('cod_mes', $request->input('cod_mes'))
                               ->get()->toArray();
    }

    private function agregarDistribucionPartesIguales($contrato, $institucion, $ano, $mes) {
        $partesIguales = \DB::select("select dcc.dco_centro_no_final as cco_no_final,
                                             dcc.dco_centro_final as cco_final,
                                             cp.cpr_total as costo_primario,
                                             cp.cpr_costos_directos * (dcb.dcb_ponderacion / 100) / (
                                                select count(*)
                                                from costos_principal.distribucion_costos_centros
                                                where con_fk_id = ".$contrato." and
                                                      ins_fk_id = '".$institucion."' and
                                                      dco_ano = ".$ano." and
                                                      dco_centro_no_final = dcc.dco_centro_no_final
                                             ) as costo_directo_dist,
                                             cp.cpr_costos_indirectos * (dcb.dcb_ponderacion / 100) / (
                                                select count(*)
                                                from costos_principal.distribucion_costos_centros
                                                where con_fk_id = ".$contrato." and
                                                      ins_fk_id = '".$institucion."' and
                                                      dco_ano = ".$ano." and
                                                      dco_centro_no_final = dcc.dco_centro_no_final
                                             ) as costo_indirecto_dist,
                                             cp.cpr_costos_fijos * (dcb.dcb_ponderacion / 100) / (
                                                select count(*)
                                                from costos_principal.distribucion_costos_centros
                                                where con_fk_id = ".$contrato." and
                                                      ins_fk_id = '".$institucion."' and
                                                      dco_ano = ".$ano." and
                                                      dco_centro_no_final = dcc.dco_centro_no_final
                                             ) as costo_fijo_dist,
                                             cp.cpr_costos_variables * (dcb.dcb_ponderacion / 100) / (
                                                select count(*)
                                                from costos_principal.distribucion_costos_centros
                                                where con_fk_id = ".$contrato." and
                                                      ins_fk_id = '".$institucion."' and
                                                      dco_ano = ".$ano." and
                                                      dco_centro_no_final = dcc.dco_centro_no_final
                                             ) as costo_variable_dist,
                                             cp.cpr_total * (dcb.dcb_ponderacion / 100) / (
                                                select count(*)
                                                from costos_principal.distribucion_costos_centros
                                                where con_fk_id = ".$contrato." and
                                                      ins_fk_id = '".$institucion."' and
                                                      dco_ano = ".$ano." and
                                                      dco_centro_no_final = dcc.dco_centro_no_final
                                             ) as costo_dist_total
                                    from costos_principal.distribucion_costos_centros as dcc
                                    join costos_principal.distribucion_costos_bases as dcb on (dcc.dco_centro_no_final = dcb.cco_fk_id)
                                    join costos_principal.costo_primario as cp on (cp.cco_fk_id = dcc.dco_centro_no_final and
                                                                                   cp.cpr_ano = ".$ano." and cpr_mes = ".$mes.")
                                    where dcc.con_fk_id = ".$contrato." and
                                          dcc.ins_fk_id = '".$institucion."' and
                                          dco_ano = ".$ano." and
                                          dcb.bdi_fk_id = 2");

        // Determinar asignaciones realizadas
        $codDb = CostoDistribuido::on('costos_principal')
                                 ->where('con_fk_id', $contrato)
                                 ->where('ins_fk_id', $institucion)
                                 ->where('cod_ano', $ano)
                                 ->where('cod_mes', $mes)
                                 ->get()->toArray();

        $codExistentes = [];

        foreach ($codDb as $cod) {
            $codExistentes[$cod['cod_cco_no_final']][$cod['cod_cco_final']] = new \stdClass();

            $codExistentes[$cod['cod_cco_no_final']][$cod['cod_cco_final']]->cod_costo_fijo_dist = $cod['cod_costo_fijo_dist'];
            $codExistentes[$cod['cod_cco_no_final']][$cod['cod_cco_final']]->cod_costo_variable_dist = $cod['cod_costo_variable_dist'];
            $codExistentes[$cod['cod_cco_no_final']][$cod['cod_cco_final']]->cod_costo_directo_dist = $cod['cod_costo_directo_dist'];
            $codExistentes[$cod['cod_cco_no_final']][$cod['cod_cco_final']]->cod_costo_indirecto_dist = $cod['cod_costo_indirecto_dist'];
            $codExistentes[$cod['cod_cco_no_final']][$cod['cod_cco_final']]->cod_costo_dist_total = $cod['cod_costo_dist_total'];
        }

        // Agregar dsitribucion a costo distribuido
        foreach ($partesIguales as $pi) {
            // Existe la asignacion
            if (isset($codExistentes[$pi->cco_no_final][$pi->cco_final])) {
                CostoDistribuido::on('costos_principal')
                                ->where('con_fk_id', $contrato)
                                ->where('ins_fk_id', $institucion)
                                ->where('cod_ano', $ano)
                                ->where('cod_mes', $mes)
                                ->where('cod_cco_no_final', $pi->cco_no_final)
                                ->where('cod_cco_final', $pi->cco_final)
                ->update(
                    [
                        "cod_costo_fijo_dist" => doubleval($codExistentes[$pi->cco_no_final][$pi->cco_final]->cod_costo_fijo_dist) +
                                                 doubleval($pi->costo_fijo_dist),
                        "cod_costo_variable_dist" => doubleval($codExistentes[$pi->cco_no_final][$pi->cco_final]->cod_costo_variable_dist) +
                                                     doubleval($pi->costo_variable_dist),
                        "cod_costo_directo_dist" => doubleval($codExistentes[$pi->cco_no_final][$pi->cco_final]->cod_costo_directo_dist) +
                                                    doubleval($pi->costo_directo_dist),
                        "cod_costo_indirecto_dist" => doubleval($codExistentes[$pi->cco_no_final][$pi->cco_final]->cod_costo_indirecto_dist) +
                                                      doubleval($pi->costo_indirecto_dist),
                        "cod_costo_dist_total" => doubleval($codExistentes[$pi->cco_no_final][$pi->cco_final]->cod_costo_dist_total) +
                                                  doubleval($pi->costo_dist_total)
                    ]
                );

                $codExistentes[$pi->cco_no_final][$pi->cco_final]->cod_costo_fijo_dist = doubleval($codExistentes[$pi->cco_no_final][$pi->cco_final]->cod_costo_fijo_dist) +
                                                                                         doubleval($pi->costo_fijo_dist);

                $codExistentes[$pi->cco_no_final][$pi->cco_final]->cod_costo_variable_dist = doubleval($codExistentes[$pi->cco_no_final][$pi->cco_final]->cod_costo_variable_dist) +
                                                                                             doubleval($pi->costo_variable_dist);

                $codExistentes[$pi->cco_no_final][$pi->cco_final]->cod_costo_directo_dist = doubleval($codExistentes[$pi->cco_no_final][$pi->cco_final]->cod_costo_directo_dist) +
                                                                                            doubleval($pi->costo_directo_dist);

                $codExistentes[$pi->cco_no_final][$pi->cco_final]->cod_costo_indirecto_dist = doubleval($codExistentes[$pi->cco_no_final][$pi->cco_final]->cod_costo_indirecto_dist) +
                                                                                              doubleval($pi->costo_indirecto_dist);

                $codExistentes[$pi->cco_no_final][$pi->cco_final]->cod_costo_dist_total = doubleval($codExistentes[$pi->cco_no_final][$pi->cco_final]->cod_costo_dist_total) +
                                                                                          doubleval($pi->costo_dist_total);
            } else { // Toca crear la asignacion
                CostoDistribuido::on('costos_principal')->create(
                    [
                        "con_fk_id" => $contrato,
                        "ins_fk_id" => $institucion,
                        "cod_ano" => $ano,
                        "cod_mes" => $mes,
                        "cod_cco_no_final" => $pi->cco_no_final,
                        "cod_costo_primario" => $pi->costo_primario,
                        "cod_cco_final" => $pi->cco_final,
                        "cod_costo_fijo_dist" => $pi->costo_fijo_dist,
                        "cod_costo_variable_dist" => $pi->costo_variable_dist,
                        "cod_costo_directo_dist" => $pi->costo_directo_dist,
                        "cod_costo_indirecto_dist" => $pi->costo_indirecto_dist,
                        "cod_costo_dist_total" => $pi->costo_dist_total
                    ]
                );

                $codExistentes[$pi->cco_no_final][$pi->cco_final] = new \stdClass();

                $codExistentes[$pi->cco_no_final][$pi->cco_final]->cod_costo_fijo_dist = $pi->costo_fijo_dist;
                $codExistentes[$pi->cco_no_final][$pi->cco_final]->cod_costo_variable_dist = $pi->costo_variable_dist;
                $codExistentes[$pi->cco_no_final][$pi->cco_final]->cod_costo_directo_dist = $pi->costo_directo_dist;
                $codExistentes[$pi->cco_no_final][$pi->cco_final]->cod_costo_indirecto_dist = $pi->costo_indirecto_dist;
                $codExistentes[$pi->cco_no_final][$pi->cco_final]->cod_costo_dist_total = $pi->costo_dist_total;
            }
        }
    }

    private function consolidarCostoTotal($contrato, $institucion, $ano, $mes) {
        \DB::select("insert into costos_principal.costo_total (con_fk_id, ins_fk_id, cot_ano, cot_mes, cco_fk_id, cot_cp_fijo, cot_cp_variable,
                                                               cot_cp_directo, cot_cp_indirecto, cot_cp_total, cot_cd_fijo, cot_cd_variable,
                                                               cot_cd_directo, cot_cd_indirecto, cot_dist_total, cot_costo_fijo_total,
                                                               cot_costo_variable_total, cot_costo_directo_total, cot_costo_indirecto_total,
                                                               cot_costo_total)
                    select ".$contrato.",
                           '".$institucion."',
                           ".$ano.",
                           ".$mes.",
                           cco.cco_pk_id,
                           coalesce(cp.cpr_costos_fijos, 0) cp_fijo,
                           coalesce(cp.cpr_costos_variables, 0) cp_variable,
                           coalesce(cp.cpr_costos_directos, 0) cp_directo,
                           coalesce(cp.cpr_costos_indirectos, 0) cp_indirecto,
                           coalesce(cp.cpr_total, 0) cp_total,
                           coalesce(cd.costo_fijo, 0) cd_fijo,
                           coalesce(cd.costo_variable, 0) cd_variable,
                           coalesce(cd.costo_directo, 0) cd_directo,
                           coalesce(cd.costo_indirecto, 0) cd_indirecto,
                           coalesce(cd.total, 0) as cd_total,
                           coalesce(cp.cpr_costos_fijos, 0) + coalesce(cd.costo_fijo, 0) as costo_fijo_total,
                           coalesce(cp.cpr_costos_variables, 0) + coalesce(cd.costo_variable, 0) as costo_variable_total,
                           coalesce(cp.cpr_costos_directos, 0) + coalesce(cd.costo_directo, 0) as costo_directo_total,
                           coalesce(cp.cpr_costos_indirectos, 0) + coalesce(cd.costo_indirecto, 0) as costo_indirecto_total,
                           coalesce(cp.cpr_total, 0) + coalesce(cd.total, 0) as costo_total
                   from costos_principal.centros_costo as cco
                   left join costos_principal.costo_primario as cp on (cco.cco_pk_id = cp.cco_fk_id and
                                                                       cp.con_fk_id = ".$contrato." and
                                                                       cp.ins_fk_id = '".$institucion."' and
                                                                       cp.cpr_ano = ".$ano." and
                                                                       cp.cpr_mes = ".$mes.")
                   left join (
                       select cod_cco_final as cco_final,
                              sum(cod_costo_fijo_dist) as costo_fijo,
                              sum(cod_costo_variable_dist) as costo_variable,
                              sum(cod_costo_directo_dist) as costo_directo,
                              sum(cod_costo_indirecto_dist) as costo_indirecto,
                              sum(cod_costo_dist_total) as total
                       from costos_principal.costo_distribuido
                       where con_fk_id = ".$contrato." and
                             ins_fk_id = '".$institucion."' and
                             cod_ano = ".$ano." and
                             cod_mes = ".$mes."
                       group by 1
                   ) as cd on (cd.cco_final = cco.cco_pk_id)
                   where cco.con_fk_id = ".$contrato." and
                         cco.ins_fk_id = '".$institucion."' and
                         cco.cco_ano = ".$ano." and
                         cco.cco_final = true");
    }

    private function consolidarCostosIngresos($contrato, $institucion, $ano, $mes) {
        \DB::select("insert into costos_principal.costos_ingresos (con_fk_id, ins_fk_id, coi_ano, coi_mes, cco_fk_id, coi_costo, coi_ingresos)
                    select ".$contrato.",
                           '".$institucion."',
                           ".$ano.",
                           ".$mes.",
                           cco_pk_id,
                           coalesce(cos.costo, 0) as costos,
                           coalesce(ing.ingresos, 0) as ingresos
                    from costos_principal.centros_costo as cco
                    left join (
                        select cco_fk_id,
                               coalesce(sum(cot_costo_total), 0) as costo
                        from costos_principal.costo_total
                        where con_fk_id = ".$contrato." and
                              ins_fk_id = '".$institucion."' and
                              cot_ano = ".$ano." and
                              cot_mes = ".$mes."
                        group by 1
                    ) as cos on (cos.cco_fk_id = cco.cco_pk_id)
                    left join (
                        select cco_fk_id,
                               coalesce(sum(rcc_valor), 0) as ingresos
                        from costos_principal.recursos_centro_costo
                        where con_fk_id = ".$contrato." and
                              ins_fk_id = '".$institucion."' and
                              rcc_ano = ".$ano." and
                              rcc_mes = ".$mes." and
                              elm_fk_id = 1
                        group by 1
                    ) as ing on (ing.cco_fk_id = cco.cco_pk_id)
                    where con_fk_id = ".$contrato." and
                          ins_fk_id = '".$institucion."' and
                          cco_ano = ".$ano." and
                          (cos.costo != 0 or ing.ingresos != 0)");
    }
}
