<?php

namespace App\Http\Controllers;

use App\Models\DetalleSuministros;
use App\Models\CentrosCosto;
use App\Models\Suministros;
use App\Models\AvanceModulos;
use Illuminate\Http\Request;

class DetalleSuministrosController extends Controller
{
    private $apiKey;

    function __construct() {
        $apiController = new ApiController();

        $this->apiKey = $apiController->getApiKey()["key"];
    }

    public function crearDetalleSuministros(Request $request) {
        $id = new \stdClass();

        \DB::transaction(function() use(&$id, $request) {
            $detalle = DetalleSuministros::on('costos_principal');

            $id = $detalle->create(
                [
                    "con_fk_id" => $request->input("con_fk_id"),
                    "ins_fk_id" => $request->input("ins_fk_id"),
                    "des_ano" => $request->input("des_ano"),
                    "des_mes" => $request->input("des_mes"),
                    "des_codigo" => $request->input("des_codigo"),
                    "cco_fk_id" => $request->input("cco_fk_id"),
                    "sum_fk_id" => $request->input("sum_fk_id"),
                    "des_cantidad" => $request->input("des_cantidad"),
                    "des_valor_unitario" => $request->input("des_valor_unitario")
                ]
            );

            $this->verificarAvance($request->input("con_fk_id"),
                                   $request->input("ins_fk_id"),
                                   $request->input("des_ano"),
                                   $request->input("des_mes"));
        });

        return array("response" => $id->des_pk_id);
    }

    public function actualizarDetalleSuministos(Request $request) {
        DetalleSuministros::on('costos_principal')
                          ->where("con_fk_id", $request->input("con_fk_id"))
                          ->where("ins_fk_id", $request->input("ins_fk_id"))
                          ->where("des_ano", $request->input("des_ano"))
                          ->where("des_mes", $request->input("des_mes"))
                          ->where("cco_fk_id", $request->input("cco_fk_id"))
                          ->where("sum_fk_id", $request->input("sum_fk_id"))
        ->update(
            [
                "des_cantidad" => $request->input("des_cantidad"),
                "des_valor_unitario" => $request->input("des_valor_unitario")
            ]
        );
    }

    public function borrarDetalleSuministros(Request $request) {
        \DB::transaction(function() use($request) {
            DetalleSuministros::on('costos_principal')
                              ->where("des_pk_id", $request->input("des_pk_id"))
                              ->delete();

            $this->verificarAvance($request->input("con_fk_id"),
                                   $request->input("ins_fk_id"),
                                   $request->input("des_ano"),
                                   $request->input("des_mes"));
        });
    }

    public function getDetalleSuministros(Request $request) {
        return DetalleSuministros::on('costos_principal')
                                 ->where('con_fk_id', $request->input('con_fk_id'))
                                 ->where('ins_fk_id', $request->input('ins_fk_id'))
                                 ->where('des_ano', $request->input('des_ano'))
                                 ->where('des_mes', $request->input('des_mes'))
                                 ->get()->toArray();

    }

    public function getDetalleSuministrosEspecifico(Request $request) {
        return DetalleSuministros::on('costos_principal')
                                 ->where('con_fk_id', $request->input('con_fk_id'))
                                 ->where('ins_fk_id', $request->input('ins_fk_id'))
                                 ->where('des_ano', $request->input('des_ano'))
                                 ->where('des_mes', $request->input('des_mes'))
                                 ->where('cco_fk_id', $request->input('cco_fk_id'))
                                 ->where('sum_fk_id', $request->input('sum_fk_id'))
                                 ->get()->toArray();

    }

    public function cargarArchivoDetalleSuministros(Request $request) {
        $apiKey = $request->apiKey;

        if ($apiKey === $this->apiKey) {
            $rutaDelArchivo = $request->detalleSuministros->path();
            $delimitador = $request->delimitador;
            $archivo = fopen($rutaDelArchivo, 'r');
            $detalleSuministros = array();
            $primeraLinea = true;

            // Extraer cada línea del archivo CSV y convertirlo en un arreglo
            while($linea = fgetcsv($archivo, 1000, $delimitador)) {
                if (!$primeraLinea) {
                    $registro = $linea;
                    array_push($detalleSuministros, $registro);
                } else {
                    $primeraLinea = false;
                }
            }

            fclose($archivo);

            return $this->procesarArchivoDetalleSuministros($detalleSuministros,
                                                            $request->con_fk_id,
                                                            $request->ins_fk_id,
                                                            $request->des_ano,
                                                            $request->des_mes);
        } else {
            throw new \Exception('Imposible completar la petición.');
        }
    }

    private function procesarArchivoDetalleSuministros($detalleSuministros, $con_fk_id, $ins_fk_id, $des_ano, $des_mes) {
        $resultados = new \stdClass();
        $resultados->errores = "";

        \DB::transaction(function() use(&$resultados, $detalleSuministros, $con_fk_id, $ins_fk_id, $des_ano, $des_mes) {
            if (count($detalleSuministros) === 0) {
                $resultados->correcto = false;
                $resultados->errores = 'El archivo está vacío. ';
                return json_encode($resultados);
            } else if (count($detalleSuministros[0]) !== 4) {
                $resultados->correcto = false;
                $resultados->errores = 'La cantidad de columnas no corresponde. ';
                return json_encode($resultados);
            } else {
                DetalleSuministros::on('costos_principal')
                                  ->where('con_fk_id', $con_fk_id)
                                  ->where('ins_fk_id', $ins_fk_id)
                                  ->where('des_ano', $des_ano)
                                  ->where('des_mes', $des_mes)
                                  ->delete();

                $centrosCostoBd = CentrosCosto::on('costos_principal')
                                              ->where('con_fk_id', $con_fk_id)
                                              ->where('ins_fk_id', $ins_fk_id)
                                              ->where('cco_ano', $des_ano)
                                              ->get()->toArray();

                $suministrosBd = Suministros::on('costos_principal')
                                            ->where('con_fk_id', $con_fk_id)
                                            ->where('ins_fk_id', $ins_fk_id)
                                            ->where('sum_ano', $des_ano)
                                            ->get()->toArray();

                $detalleSuministrosBd = DetalleSuministros::on('costos_principal')
                                                          ->where('con_fk_id', $con_fk_id)
                                                          ->where('ins_fk_id', $ins_fk_id)
                                                          ->where('des_ano', $des_ano)
                                                          ->where('des_mes', $des_mes)
                                                          ->get()->toArray();

                $centrosCostoExistentes = [];
                $suministrosExistentes = [];
                $detalleSuminsitrosExistentes = [];
                $registrosProcesados = 0;

                // Crear las relaciones existentes en la base de datos
                foreach ($centrosCostoBd as $ccoDb) {
                    $centrosCostoExistentes[$ccoDb['cco_cod_homologado']] = $ccoDb['cco_pk_id'];
                }

                foreach ($suministrosBd as $sumDb) {
                    $suministrosExistentes[$sumDb['sum_codigo']] = $sumDb['sum_pk_id'];
                }

                // Errores de los centros de utilidad
                $centrosCostoErroneos = "";
                $suministrosErroneos = "";
                $valoresIncorrectos = false;

                // Revisar el archivo respecto a las relaciones existentes
                foreach($detalleSuministros as $desCsv) {
                    $centroCosto = strtoupper($desCsv[0]);
                    $suministro = strtoupper($desCsv[1]);
                    $cantidad = $desCsv[2];
                    $valor = $desCsv[3];

                    // Existe el centro de costo
                    if (is_numeric($cantidad) && $cantidad > 0 && is_numeric($valor) && $valor > 0) {
                        if (isset($centrosCostoExistentes[$centroCosto])) {
                            // Existe el suministro
                            if (isset($suministrosExistentes[$suministro])) {
                                if (isset($detalleSuministrosExistentes[$centrosCostoExistentes[$centroCosto]][$suministrosExistentes[$suministro]])) {
                                    // Actualizar si hay diferencias
                                    if ($detalleSuministrosExistentes[$centrosCostoExistentes[$centroCosto]]
                                                                     [$suministrosExistentes[$suministro]]->des_cantidad != $cantidad ||
                                        $detalleSuministrosExistentes[$centrosCostoExistentes[$centroCosto]]
                                                                     [$suministrosExistentes[$suministro]]->des_valor_unitario != $valor) {
                                        DetalleSuministros::on('costos_principal')
                                                          ->where("con_fk_id", $con_fk_id)
                                                          ->where("ins_fk_id", $ins_fk_id)
                                                          ->where("des_ano", $des_ano)
                                                          ->where("des_mes", $des_mes)
                                                          ->where("cco_fk_id", $centrosCostoExistentes[$centroCosto])
                                                          ->where("sum_fk_id", $suministrosExistentes[$suministro])
                                        ->update(
                                            [
                                                "des_cantidad" => $cantidad,
                                                "des_valor_unitario" => $valor
                                            ]
                                        );

                                        $registrosProcesados++;
                                    } else {
                                        $registrosProcesados++;
                                    }
                                } else { // Nuevo registro
                                    DetalleSuministros::on('costos_principal')
                                    ->create(
                                        [
                                            "con_fk_id" => $con_fk_id,
                                            "ins_fk_id" => $ins_fk_id,
                                            "des_ano" => $des_ano,
                                            "des_mes" => $des_mes,
                                            "cco_fk_id" => $centrosCostoExistentes[$centroCosto],
                                            "sum_fk_id" => $suministrosExistentes[$suministro],
                                            "des_cantidad" => $cantidad,
                                            "des_valor_unitario" => $valor
                                        ]
                                    );

                                    $registrosProcesados++;

                                    $detalleSuministrosExistentes[$centrosCostoExistentes[$centroCosto]][$suministrosExistentes[$suministro]] = new \stdClass();

                                    $detalleSuministrosExistentes[$centrosCostoExistentes[$centroCosto]]
                                                                 [$suministrosExistentes[$suministro]]->des_cantidad = $cantidad;

                                    $detalleSuministrosExistentes[$centrosCostoExistentes[$centroCosto]]
                                                                 [$suministrosExistentes[$suministro]]->des_valor_unitario = $valor;
                                }
                            } else {
                                $suministrosErroneos .= $suministro.", ";
                            }
                        } else {
                            $centrosCostoErroneos .= $centroCosto.", ";
                        }
                    } else {
                        $valoresIncorrectos = true;
                    }
                }

                // Errores de centros de costo
                if ($centrosCostoErroneos !== "") {
                    $centrosCostoErroneos[strlen($centrosCostoErroneos) - 1] = " ";
                    $centrosCostoErroneos[strlen($centrosCostoErroneos) - 2] = " ";
                    $centrosCostoErroneos = "Los siguientes códigos de centros de costo no existen: ".$centrosCostoErroneos;

                    if ($resultados->errores !== "") {
                        $resultados->errores .= "-  ";
                    }

                    $resultados->errores .= $centrosCostoErroneos;
                }

                // Errores de suministros
                if ($suministrosErroneos !== "") {
                    $suministrosErroneos[strlen($suministrosErroneos) - 1] = " ";
                    $suministrosErroneos[strlen($suministrosErroneos) - 2] = " ";
                    $suministrosErroneos = "Los siguientes códigos de suministros no existen: ".$suministrosErroneos;

                    if ($resultados->errores !== "") {
                        $resultados->errores .= "-  ";
                    }

                    $resultados->errores .= $suministrosErroneos;
                }

                // Descripciones largas
                if ($valoresIncorrectos) {
                    if ($resultados->errores !== "") {
                        $resultados->errores .= "-  ";
                    }

                    $resultados->errores .= "Hay valores númericos incorrectos (los decimales deben ser separados por un punto) o menores que 0";
                }

                if (!$valoresIncorrectos && $centrosCostoErroneos === "" && $suministrosErroneos === "") {
                    $resultados->correcto = true;
                } else {
                    $resultados->correcto = false;
                }

                $resultados->registros = $registrosProcesados;
            }

            $this->verificarAvance($con_fk_id, $ins_fk_id, $des_ano, $des_mes);
        });

        return json_encode($resultados);
    }

    public function verificarAvance($contrato, $institucion, $ano, $mes) {
        // Verificar si existe registro del avance
        $conteo = AvanceModulos::on('costos_principal')
                               ->where('con_fk_id', $contrato)
                               ->where('ins_fk_id', $institucion)
                               ->where('avm_ano', $ano)
                               ->where('avm_mes', $mes)
                               ->count();

        // Verificar el avance del modulo
        $des = DetalleSuministros::on('costos_principal')
                                 ->where('con_fk_id', $contrato)
                                 ->where('ins_fk_id', $institucion)
                                 ->where('des_ano', $ano)
                                 ->where('des_mes', $mes)
                                 ->count();

        if ($conteo > 0) {
            if ($des > 0) {
                AvanceModulos::on('costos_principal')
                                ->where('con_fk_id', $contrato)
                                ->where('ins_fk_id', $institucion)
                                ->where('avm_ano', $ano)
                                ->where('avm_mes', $mes)
                ->update(
                    [
                        "avm_det_sum" => true
                    ]
                );
            } else {
               AvanceModulos::on('costos_principal')
                            ->where('con_fk_id', $contrato)
                            ->where('ins_fk_id', $institucion)
                            ->where('avm_ano', $ano)
                            ->where('avm_mes', $mes)
                ->update(
                    [
                        "avm_det_sum" => false
                    ]
                ); 
            }
        } else {
            AvanceModulos::on('costos_principal')
            ->create(
                [
                    "con_fk_id" => $contrato,
                    "ins_fk_id" => $institucion,
                    "avm_ano" => $ano,
                    "avm_mes" => $mes,
                    "avm_det_sum" => true
                ]
            );
        }            
    }
}
