<?php

namespace App\Http\Controllers;

use App\Models\InformacionProduccion;
use App\Models\Actividades;
use App\Models\CentrosCosto;
use App\Models\ActividadesCentroCosto;
use App\Models\Suministros;
use App\Models\ContratosEps;
use App\Models\InformacionBasesDistribucion;
use App\Models\InformacionBasesDistribucion2;
use App\Models\Programas;
use App\Models\EstadiosProgramas;
use App\Models\SedesProgramas;
use App\Models\ActividadesProgramas;
use Illuminate\Http\Request;

class InformacionProduccionController extends Controller
{
  private $apiKey;

  function __construct() {
    $apiController = new ApiController();

    $this->apiKey = $apiController->getApiKey()["key"];
  }

  public function getInformacionProduccion(Request $request) {
    return InformacionProduccion::on('costos_principal')
                  ->selectRaw('cco_fk_id, act_codigo, act_descripcion, sum_codigo, sum_nombre, ipr_actividad, coe_numero_contrato,
                               prg_codigo, esp_codigo, coe_nit_eps, coe_nombre_eps, ipr_cantidad, ipr_valor')
                  ->leftJoin('actividades', 'act_pk_id', 'act_fk_id')
                  ->leftJoin('suministros', 'sum_pk_id', 'sum_fk_id')
                  ->join('contratos_eps', 'coe_pk_id', 'coe_fk_id')
                  ->leftJoin('programas', 'prg_pk_id', 'prg_fk_id')
                  ->leftJoin('estadios_programas', 'esp_pk_id', 'esp_fk_id')
                  ->where('informacion_produccion.con_fk_id', $request->input('con_fk_id'))
                  ->where('informacion_produccion.ins_fk_id', $request->input('ins_fk_id'))
                  ->where('ipr_ano', $request->input('ipr_ano'))
                  ->where('ipr_mes', $request->input('ipr_mes'))
                  ->get()->toArray();
  }

  public function borrarInformacionProduccion(Request $request) {
    \DB::transaction(function() use($request) {
      InformacionProduccion::on('costos_principal')
                 ->where('ipr_pk_id', $request->input('ipr_pk_id'))
                 ->delete();

      $this->generarInformacionBasesDistribucion($request->input('con_fk_id'),
                             $request->input('ins_fk_id'),
                             $request->input('ipr_ano'),
                             $request->input('ipr_mes'));
    });
  }

  public function cargarArchivoInformacionProduccion(Request $request) {
    $apiKey = $request->apiKey;

    if ($apiKey === $this->apiKey) {
      $rutaDelArchivo = $request->informacionProduccion->path();
      $delimitador = $request->delimitador;
      $archivo = fopen($rutaDelArchivo, 'r');
      $informacionProduccion = array();
      $primeraLinea = true;

      // Extraer cada línea del archivo CSV y convertirlo en un arreglo
      while($linea = fgetcsv($archivo, 1000, $delimitador)) {
        if (!$primeraLinea) {
          $registro = $linea;
          array_push($informacionProduccion, $registro);
        } else {
          $primeraLinea = false;
        }
      }

      fclose($archivo);

      return $this->procesarArchivoInformacionProduccion($informacionProduccion,
                                 $request->con_fk_id,
                                 $request->ins_fk_id,
                                 $request->ipr_ano,
                                 $request->ipr_mes);
    } else {
      throw new \Exception('Imposible completar la petición.');
    }
  }

  private function procesarArchivoInformacionProduccion($informacionProduccion, $con_fk_id, $ins_fk_id, $ipr_ano, $ipr_mes) {
    $resultados = new \stdClass();
    $resultados->errores = "";

    \DB::transaction(function() use($informacionProduccion, $con_fk_id, $ins_fk_id, $ipr_ano, $ipr_mes, $resultados) {
      if (count($informacionProduccion) === 0) {
        $resultados->correcto = false;
        $resultados->errores = 'El archivo está vacío. ';
      } else if (count($informacionProduccion[0]) !== 8) {
        $resultados->correcto = false;
        $resultados->errores = 'La cantidad de columnas no corresponde. ';
      } else {
        // Borrar la produccion actual
        InformacionProduccion::on('costos_principal')
                   ->where('con_fk_id', $con_fk_id)
                   ->where('ins_fk_id', $ins_fk_id)
                   ->where('ipr_ano', $ipr_ano)
                   ->where('ipr_mes', $ipr_mes)
                   ->delete();

        // Parametros de la base de datos
        $actividadesBd = Actividades::on('costos_principal')
                      ->where('con_fk_id', $con_fk_id)
                      ->where('ins_fk_id', $ins_fk_id)
                      ->where('act_ano', $ipr_ano)
                      ->get()->toArray();

        $centrosCostoBd = CentrosCosto::on('costos_principal')
                        ->where('con_fk_id', $con_fk_id)
                        ->where('ins_fk_id', $ins_fk_id)
                        ->where('cco_ano', $ipr_ano)
                        ->where('cco_final', true)
                        ->get()->toArray();

        $actividadesCcoBd = ActividadesCentroCosto::on('costos_principal')
                              ->where('con_fk_id', $con_fk_id)
                              ->where('ins_fk_id', $ins_fk_id)
                              ->where('acc_ano', $ipr_ano)
                              ->get()->toArray();

        $suministrosBd = Suministros::on('costos_principal')
                      ->where('con_fk_id', $con_fk_id)
                      ->where('ins_fk_id', $ins_fk_id)
                      ->where('sum_ano', $ipr_ano)
                      ->get()->toArray();

        $contratosEpsBd = ContratosEps::on('costos_principal')
                        ->where('con_fk_id', $con_fk_id)
                        ->where('ins_fk_id', $ins_fk_id)
                        ->where('coe_ano', $ipr_ano)
                        ->where('coe_activo', true)
                        ->get()->toArray();

        $programasBd = Programas::on('costos_principal')
                    ->where('con_fk_id', $con_fk_id)
                    ->where('ins_fk_id', $ins_fk_id)
                    ->where('prg_ano', $ipr_ano)
                    ->get()->toArray();

        if (count($programasBd) > 0) {
          $estadiosBd = EstadiosProgramas::on('costos_principal')
                          ->where('con_fk_id', $con_fk_id)
                          ->where('ins_fk_id', $ins_fk_id)
                          ->where('esp_ano', $ipr_ano)
                          ->get()->toArray();
                          
          $sedesProgramasBd = SedesProgramas::on('costos_principal')
                                            ->where('con_fk_id', $con_fk_id)
                                            ->where('ins_fk_id', $ins_fk_id)
                                            ->where('sep_ano', $ipr_ano)
                                            ->get()->toArray();

          /*$actividadesProgramasBd = ActividadesProgramas::on('costos_principal')
                                                        ->where('con_fk_id', $con_fk_id)
                                                        ->where('ins_fk_id', $ins_fk_id)
                                                        ->where('acp_ano', $ipr_ano)
                                                        ->get()->toArray();*/
        }

        $produccionExistente = [];
        $actividadesExistentes = [];
        $centrosCostoExistentes = [];
        $actividadesCcoExistentes = [];
        $suministrosExistentes = [];
        $contratosExistentes = [];
        $programasContratoExistentes = [];
        $programasSedesExistentes = [];
        //$actividadesProgramasExistentes = [];
        $estadiosExistentes = [];
        $registrosProcesados = 0;

        // Crear las relaciones existentes en la base de datos
        foreach ($actividadesBd as $actDb) {
          $actividadesExistentes[$actDb['act_codigo']] = $actDb['act_pk_id'];
        }

        foreach ($centrosCostoBd as $ccoDb) {
          $centrosCostoExistentes[$ccoDb['cco_cod_homologado']] = new \stdClass();
          $centrosCostoExistentes[$ccoDb['cco_cod_homologado']]->cco_pk_id = $ccoDb['cco_pk_id'];
          $centrosCostoExistentes[$ccoDb['cco_cod_homologado']]->sed_fk_id = $ccoDb['sed_fk_id'];
        }

        foreach ($actividadesCcoBd as $accDb) {
          $actividadesCcoExistentes[$accDb['cco_fk_id']][$accDb['act_fk_id']] = $accDb['acc_pk_id'];
        }

        foreach ($suministrosBd as $sumDb) {
          $suministrosExistentes[$sumDb['sum_codigo']] = $sumDb['sum_pk_id'];
        }

        foreach ($contratosEpsBd as $coeDb) {
          $contratosExistentes[$coeDb['coe_pk_id']] = $coeDb['coe_numero_contrato'];
        }

        if (count($programasBd) > 0) {
          foreach ($programasBd as $prgDb) {
            $programasContratoExistentes[$prgDb['prg_codigo']][$prgDb['coe_fk_id']] = $prgDb['prg_pk_id'];
          }

          foreach ($estadiosBd as $espDb) {
            $estadiosExistentes[$espDb['prg_fk_id']][$espDb['esp_codigo']] = $espDb['esp_pk_id'];
          }

          foreach ($sedesProgramasBd as $sepDb) {
            $programasSedesExistentes[$sepDb['prg_fk_id']][$sepDb['sed_fk_id']] = $sepDb['sep_pk_id'];
          }
        }

        // Errores
        $camposVacios = false;
        $centrosCostoInexistentes = "";
        $actividadesInexistentes = "";
        $suministrosInexistentes = "";
        $relacionesInexistentes = "";
        $contratosInexistentes = "";
        $programasInexistentes = "";
        $estadiosInexistentes = "";
        $relProgramaContratoInexistentes = "";
        $relProgramaSedeInexistentes = "";
        $numerosIncorrectos = false;
        $tiposIncorrectos = false;

        // Revisar el archivo respecto a las relaciones existentes
        foreach($informacionProduccion as $iprCsv) {
          $centroCosto = strtoupper($iprCsv[0]);
          $tipo = strtoupper($iprCsv[1]);
          $actSum = trim(strtoupper($iprCsv[2]));
          $contrato = trim($iprCsv[3]);
          $programa = trim($iprCsv[4]);
          $estadio = trim($iprCsv[5]);
          $cantidad = $iprCsv[6];
          $valor = trim($iprCsv[7]) == "" ? null : trim($iprCsv[7]);

          // Campos vacios
          if ($centroCosto != "" && $actSum != "" && $contrato != "" && $cantidad != "" && ($valor != "" || $programa != "")) {
            // Numeros incorrectos
            if (is_numeric($cantidad) && (is_numeric($valor) || $programa != "") && $cantidad > 0 && ($valor >= 0 || $programa != "")) {
              // Tipo de carga
              if ($tipo == "A" || $tipo == "S") {
                // Existe el contrato
                if (isset($contratosExistentes[$contrato])) {
                  $idContrato = $contrato;

                  // Existe el centro de costo
                  if (isset($centrosCostoExistentes[$centroCosto]->cco_pk_id)) {
                    $idCentroCosto = $centrosCostoExistentes[$centroCosto]->cco_pk_id;
                    $sedeCentroCosto = $centrosCostoExistentes[$centroCosto]->sed_fk_id;

                    // Existe la actividad / Existe el suministro
                    if (($tipo == "A" && isset($actividadesExistentes[$actSum])) || ($tipo == "S" && isset($suministrosExistentes[$actSum]))) {
                      $idActividad = 0;
                      $idSuministro = 0;

                      if ($tipo == "A") {
                        $idActividad = $actividadesExistentes[$actSum];
                      } else {
                        $idSuministro = $suministrosExistentes[$actSum];
                      }

                      // Existe la relacion cco - act
                      if (($tipo == "A" && isset($actividadesCcoExistentes[$idCentroCosto][$idActividad])) || $tipo == "S") {
                        $elemento = "";

                        if ($tipo == "A") {
                          $elemento = $idActividad;
                        } else {
                          $elemento = $idSuministro;
                        }

                        // Validar la parametrización del programa
                        if (($programa == "" && $estadio == "") || ($programa != "" && $estadio != "")) {
                          $idPrg = '0';
                          $idEsp = '0';

                          // Existe el programa
                          if ($programa == "" || isset($programasContratoExistentes[$programa])) {
                            if ($programa == "" || isset($programasContratoExistentes[$programa][$contrato])) {
                              if ($programa != "") {
                                $idPrg = $programasContratoExistentes[$programa][$contrato];
                              }

                              // Existe la relación entre sede-programa
                              if ($programa == "" || isset($programasSedesExistentes[$idPrg][$sedeCentroCosto])) {
                                // Existe el estadío
                                if ($programa == "" || isset($estadiosExistentes[$idPrg][$estadio])) {
                                  if ($programa != "") {
                                    $idEsp = $estadiosExistentes[$idPrg][$estadio];
                                  }

                                  // Existe el registro
                                  if (isset($produccionExistente[$tipo][$idCentroCosto][$elemento][$idContrato][$idPrg][$idEsp])) {
                                    // Actualizar si hay diferencias
                                    if ($produccionExistente[$tipo][$idCentroCosto][$elemento][$idContrato][$idPrg][$idEsp]->ipr_cantidad != $cantidad ||
                                        $produccionExistente[$tipo][$idCentroCosto][$elemento][$idContrato][$idPrg][$idEsp]->ipr_valor != $valor) {
                                      // Actividades
                                      if ($tipo == "A") {
                                        $ipr = InformacionProduccion::on('costos_principal')
                                                      ->where("con_fk_id", $con_fk_id)
                                                      ->where("ins_fk_id", $ins_fk_id)
                                                      ->where("ipr_ano", $ipr_ano)
                                                      ->where("ipr_mes", $ipr_mes)
                                                      ->where("cco_fk_id", $idCentroCosto)
                                                      ->where("act_fk_id", $elemento)
                                                      ->where("coe_fk_id", $idContrato);

                                        if ($idPrg == '0') {
                                          $ipr->whereNull("prg_fk_id")->whereNull("esp_fk_id")
                                          ->update(
                                            [
                                              "ipr_cantidad" => $cantidad,
                                              "ipr_valor" => $valor,
                                            ]
                                          );
                                        } else {
                                          $ipr->where("prg_fk_id", $idPrg)->where("esp_fk_id", $idEsp)
                                          ->update(
                                            [
                                              "ipr_cantidad" => $cantidad
                                            ]
                                          );
                                        }
                                      } else { // Suministros
                                        $ipr = InformacionProduccion::on('costos_principal')
                                                  ->where("con_fk_id", $con_fk_id)
                                                  ->where("ins_fk_id", $ins_fk_id)
                                                  ->where("ipr_ano", $ipr_ano)
                                                  ->where("ipr_mes", $ipr_mes)
                                                  ->where("cco_fk_id", $idCentroCosto)
                                                  ->where("sum_fk_id", $elemento)
                                                  ->where("coe_fk_id", $idContrato);

                                        if ($idPrg == '0') {
                                          $ipr->whereNull("prg_fk_id")->whereNull("esp_fk_id")
                                          ->update(
                                            [
                                              "ipr_cantidad" => $cantidad,
                                              "ipr_valor" => $valor,
                                            ]
                                          );
                                        } else {
                                          $ipr->where("prg_fk_id", $idPrg)->where("esp_fk_id", $idEsp)
                                          ->update(
                                            [
                                              "ipr_cantidad" => $cantidad
                                            ]
                                          );
                                        }
                                      }

                                      $registrosProcesados++;
                                    } else {
                                      $registrosProcesados++;
                                    }
                                  } else { // No existe, es necesario crearlo
                                    $produccionNuevo = InformacionProduccion::on('costos_principal');

                                    // Actividades
                                    if ($tipo == "A") {
                                      $id = $produccionNuevo->create(
                                        [
                                          "con_fk_id" => $con_fk_id,
                                          "ins_fk_id" => $ins_fk_id,
                                          "ipr_ano" => $ipr_ano,
                                          "ipr_mes" => $ipr_mes,
                                          "cco_fk_id" => $idCentroCosto,
                                          "act_fk_id" => $elemento,
                                          "sum_fk_id" => null,
                                          "coe_fk_id" => $idContrato,
                                          "prg_fk_id" => $idPrg == '0' ? null : $idPrg,
                                          "esp_fk_id" => $idEsp == '0' ? null : $idEsp,
                                          "ipr_cantidad" => $cantidad,
                                          "ipr_valor" => $programa != "" ? null : $valor,
                                          "ipr_actividad" => true
                                        ]
                                      );
                                    } else {
                                      $id = $produccionNuevo->create(
                                        [
                                          "con_fk_id" => $con_fk_id,
                                          "ins_fk_id" => $ins_fk_id,
                                          "ipr_ano" => $ipr_ano,
                                          "ipr_mes" => $ipr_mes,
                                          "cco_fk_id" => $idCentroCosto,
                                          "act_fk_id" => null,
                                          "sum_fk_id" => $elemento,
                                          "coe_fk_id" => $idContrato,
                                          "prg_fk_id" => $idPrg == '0' ? null : $idPrg,
                                          "esp_fk_id" => $idEsp == '0' ? null : $idEsp,
                                          "ipr_cantidad" => $cantidad,
                                          "ipr_valor" => $programa != "" ? null : $valor,
                                          "ipr_actividad" => false
                                        ]
                                      );
                                    }

                                    $registrosProcesados++;

                                    $produccionExistente[$tipo][$idCentroCosto][$elemento][$idContrato][$idPrg][$idEsp] = new \stdClass();

                                    $produccionExistente[$tipo][$idCentroCosto][$elemento][$idContrato][$idPrg][$idEsp]->ipr_cantidad = $cantidad;
                                    $produccionExistente[$tipo][$idCentroCosto][$elemento][$idContrato][$idPrg][$idEsp]->ipr_valor = $programa != "" ? null : $valor;
                                  }
                                } else {
                                  $estadiosInexistentes .= $estadio.' en '.$programa.", ";
                                }
                              } else {
                                $relProgramaSedeInexistentes .= $sedeCentroCosto.' en '.$programa.", ";
                              }
                            } else {
                              $relProgramaContratoInexistentes .= $contrato.' en '.$programa.", ";
                            }
                          } else {
                            $programasInexistentes .= $programa.", ";
                          }
                        } else {
                          $camposVacios = true;
                        }
                      } else {
                        $relacionesInexistentes .= $centroCosto."-".$actSum.", ";
                      }
                    } else {
                      if ($tipo == "A") {
                        $actividadesInexistentes .= $actSum.", ";
                      } else {
                        $suministrosInexistentes .= $actSum.", ";
                      }
                    }
                  } else {
                    $centrosCostoInexistentes .= $centroCosto.", ";
                  }
                } else {
                  $contratosInexistentes .= $contrato.", ";
                }
              } else {
                $tiposIncorrectos = true;
              }
            } else {
              $numerosIncorrectos = true;
            }
          } else {
            $camposVacios = true;
          }
        }

        // Campos vacios
        if ($camposVacios) {
          if ($resultados->errores !== "") {
            $resultados->errores .= " -  ";
          }
  
          $resultados->errores .= "Hay campos vacíos. Recuerde que el campo programa y estadío deben estar vacíos si no aplica.";
        }
  
        // Valores numericos incorrectos
        if ($numerosIncorrectos) {
          if ($resultados->errores !== "") {
            $resultados->errores .= " -  ";
          }
  
          $resultados->errores .= "Hay valores numéricos incorrectos.";
        }

        // Valores numericos incorrectos
        if ($tiposIncorrectos) {
          if ($resultados->errores !== "") {
            $resultados->errores .= " -  ";
          }
  
          $resultados->errores .= "Hay tipos incorrectos. Deben ser 'A' o 'S'.";
        }
  
        // Errores de contratos de costo
        if ($contratosInexistentes !== "") {
          $contratosInexistentes[strlen($contratosInexistentes) - 1] = " ";
          $contratosInexistentes[strlen($contratosInexistentes) - 2] = " ";
          $contratosInexistentes = "No existen los siguientes contratos: ".utf8_encode($contratosInexistentes);
  
          if ($resultados->errores !== "") {
            $resultados->errores .= " -  ";
          }
  
          $resultados->errores .= $contratosInexistentes;
        }

        // Errores de centros de costo
        if ($centrosCostoInexistentes !== "") {
          $centrosCostoInexistentes[strlen($centrosCostoInexistentes) - 1] = " ";
          $centrosCostoInexistentes[strlen($centrosCostoInexistentes) - 2] = " ";
          $centrosCostoInexistentes = "No existen los siguientes centros de costo o no son centros finales: ".utf8_encode($centrosCostoInexistentes);
  
          if ($resultados->errores !== "") {
            $resultados->errores .= " -  ";
          }
  
          $resultados->errores .= $centrosCostoInexistentes;
        }
  
        // Errores de actividades
        if ($actividadesInexistentes !== "") {
          $actividadesInexistentes[strlen($actividadesInexistentes) - 1] = " ";
          $actividadesInexistentes[strlen($actividadesInexistentes) - 2] = " ";
          $actividadesInexistentes = "No existen las siguientes actividades: ".utf8_encode($actividadesInexistentes);
  
          if ($resultados->errores !== "") {
            $resultados->errores .= " -  ";
          }
  
          $resultados->errores .= $actividadesInexistentes;
        }
  
        // Errores de relaciones
        if ($relacionesInexistentes !== "") {
          $relacionesInexistentes[strlen($relacionesInexistentes) - 1] = " ";
          $relacionesInexistentes[strlen($relacionesInexistentes) - 2] = " ";
          $relacionesInexistentes = "No existen las siguientes relaciones actividad-centro costo: ".utf8_encode($relacionesInexistentes);
  
          if ($resultados->errores !== "") {
            $resultados->errores .= " -  ";
          }
  
          $resultados->errores .= $relacionesInexistentes;
        }

        // Errores de suministros
        if ($suministrosInexistentes !== "") {
          $suministrosInexistentes[strlen($suministrosInexistentes) - 1] = " ";
          $suministrosInexistentes[strlen($suministrosInexistentes) - 2] = " ";
          $suministrosInexistentes = "No existen los siguientes suministros: ".utf8_encode($suministrosInexistentes);
  
          if ($resultados->errores !== "") {
            $resultados->errores .= " -  ";
          }
  
          $resultados->errores .= $suministrosInexistentes;
        }

        // Errores de programas
        if ($programasInexistentes !== "") {
          $programasInexistentes[strlen($programasInexistentes) - 1] = " ";
          $programasInexistentes[strlen($programasInexistentes) - 2] = " ";
          $programasInexistentes = "No existen los siguientes programas: ".utf8_encode($programasInexistentes);
  
          if ($resultados->errores !== "") {
            $resultados->errores .= " -  ";
          }
  
          $resultados->errores .= $programasInexistentes;
        }

         // Errores de estadíos
         if ($estadiosInexistentes !== "") {
          $estadiosInexistentes[strlen($estadiosInexistentes) - 1] = " ";
          $estadiosInexistentes[strlen($estadiosInexistentes) - 2] = " ";
          $estadiosInexistentes = "No existen los siguientes estadíos en el programa: ".utf8_encode($estadiosInexistentes);
  
          if ($resultados->errores !== "") {
            $resultados->errores .= " -  ";
          }
  
          $resultados->errores .= $estadiosInexistentes;
        }

        // Errores de rel contrato - programa
        if ($relProgramaContratoInexistentes !== "") {
          $relProgramaContratoInexistentes[strlen($relProgramaContratoInexistentes) - 1] = " ";
          $relProgramaContratoInexistentes[strlen($relProgramaContratoInexistentes) - 2] = " ";
          $relProgramaContratoInexistentes = "No existen las siguientes relaciones entre contrato-programa: ".utf8_encode($relProgramaContratoInexistentes);
  
          if ($resultados->errores !== "") {
            $resultados->errores .= " -  ";
          }
  
          $resultados->errores .= $relProgramaContratoInexistentes;
        }

        // Errores de rel sede - programa
        if ($relProgramaSedeInexistentes !== "") {
          $relProgramaSedeInexistentes[strlen($relProgramaSedeInexistentes) - 1] = " ";
          $relProgramaSedeInexistentes[strlen($relProgramaSedeInexistentes) - 2] = " ";
          $relProgramaSedeInexistentes = "No existen las siguientes relaciones entre sede-programa: ".utf8_encode($relProgramaSedeInexistentes);
  
          if ($resultados->errores !== "") {
            $resultados->errores .= " -  ";
          }
  
          $resultados->errores .= $relProgramaSedeInexistentes;
        }
  
        if (!$camposVacios && !$tiposIncorrectos && $numerosIncorrectos == "" && $contratosInexistentes == "" && $actividadesInexistentes == "" &&
          $centrosCostoInexistentes == "" && $relacionesInexistentes == "" && $suministrosInexistentes == "" && $programasInexistentes == "" &&
          $estadiosInexistentes == "" && $relProgramaContratoInexistentes == "" && $relProgramaSedeInexistentes == "") {
          $resultados->correcto = true;
        } else {
          $resultados->correcto = false;
        }
  
        $resultados->registros = $registrosProcesados;

      }

      $this->generarInformacionBasesDistribucion($con_fk_id, $ins_fk_id, $ipr_ano, $ipr_mes);
    });

    return json_encode($resultados);
  }

  private function generarInformacionBasesDistribucion($contrato, $institucion, $ano, $mes) {
    // Borrar la informaciona anterior
    InformacionBasesDistribucion::on('costos_principal')
                  ->where('con_fk_id', $contrato)
                  ->where('ins_fk_id', $institucion)
                  ->where('ibd_ano', $ano)
                  ->where('ibd_mes', $mes)
                  ->where('bdi_fk_id', 3)
                  ->where('ibd_automatico', true)
                  ->delete();

    InformacionBasesDistribucion2::on('costos_principal')
                   ->where('con_fk_id', $contrato)
                   ->where('ins_fk_id', $institucion)
                   ->where('ibd2_ano', $ano)
                   ->where('ibd2_mes', $mes)
                   ->where('bdi_fk_id', 3)
                   ->where('ibd2_automatico', true)
                   ->delete();

    // Recalcular todos los valores
    $bd = \DB::select('select '.$contrato.' as con_fk_id,
                  \''.$institucion.'\' as ins_fk_id,
                  '.$ano.' as ibd_ano,
                  '.$mes.' as ibd_mes,
                  ipr.cco_fk_id,
                  3 as bdi_fk_id,
                  sum(ipr_cantidad) as ibd_valor,
                  true as ibd_automatico
              from costos_principal.informacion_produccion as ipr
              join costos_principal.actividades_centro_costo as acc on (acc.act_fk_id = ipr.act_fk_id and
                                            acc.cco_fk_id = ipr.cco_fk_id)
              where ipr.con_fk_id = '.$contrato.' and
                  ipr.ins_fk_id = \''.$institucion.'\' and
                  ipr_ano = '.$ano.' and
                  ipr_mes = '.$mes.' and
                  acc_suma_produccion = true
              group by 1, 2, 3, 4, 5, 6');

    foreach($bd as $row) {
      InformacionBasesDistribucion::on('costos_principal')
      ->create(
        [
          "con_fk_id" => $row->con_fk_id,
          "ins_fk_id" => $row->ins_fk_id,
          "ibd_ano" => $row->ibd_ano,
          "ibd_mes" => $row->ibd_mes,
          "cco_fk_id" => $row->cco_fk_id,
          "bdi_fk_id" => $row->bdi_fk_id,
          "ibd_valor" => $row->ibd_valor,
          "ibd_automatico" => true,
          "ibd_costo_primario" => true,
        ]
      );

      InformacionBasesDistribucion2::on('costos_principal')
      ->create(
        [
          "con_fk_id" => $row->con_fk_id,
          "ins_fk_id" => $row->ins_fk_id,
          "ibd2_ano" => $row->ibd_ano,
          "ibd2_mes" => $row->ibd_mes,
          "cco_fk_id" => $row->cco_fk_id,
          "bdi_fk_id" => $row->bdi_fk_id,
          "ibd2_valor" => $row->ibd_valor,
          "ibd2_automatico" => true
        ]
      );
    }
  }
}
