<?php

namespace App\Http\Controllers;

use App\Models\LogActividades;
use Illuminate\Http\Request;

class LogActividadesController extends Controller
{
    public function crearLog(Request $request) {
        $contrato = $request->input('contrato');
        $usuario = $request->input('usuario');
        $tipoAccion = $request->input('tipoAccion');
        $descripcion = $request->input('descripcion');

        $log = LogActividades::on('costos_principal');

        $log->create(
            [
                "log_contrato" => $contrato,
                "log_usuario" => $usuario,
                "log_tipo_accion" => $tipoAccion,
                "log_descripcion" => $descripcion
            ]
        );
    }

    public function getDetalleActividades(Request $request) {
        $fecha = $request->input('fecha');
        $fechaFin = $request->input('fechaFin');

        return \DB::select("
            select con_id_contrato as contrato,
                   usu_cuenta as cuenta_usuario,
                   usu_nombre as nombre_usuario,
                   log_descripcion as actividad,
                   loa.created_at as fecha_hora
            from costos_principal.log_actividades as loa
            left join costos_principal.contrato as con on (loa.log_contrato = cast(con.con_pk_id as text))
            left join costos_principal.usuarios as usu on (loa.log_usuario = cast(usu.usu_pk_id as text))
            where log_tipo_accion = 'Programada' and con_id_contrato is not null and usu_cuenta is not null and
                loa.created_at is not null and cast(loa.created_at as date) >= cast('".$fecha."' as date) and cast(loa.created_at as date) <= cast('".$fechaFin."' as date)
            order by loa.created_at asc
        ");
    }

    public function getLogAgrupado(Request $request) {
        $fecha = $request->input('fecha');
        $fechaFin = $request->input('fechaFin');

        return \DB::select("
            select extract(year from fecha_hora) as ano,
                   extract(month from fecha_hora) as mes,
                   contrato,
                   count(*) filter (where actividad like '%centro de utilidad%' and
                                          actividad not like 'Carga de archivo CSV') as centros_utilidad,
                   count(*) filter (where actividad like '%Carga de archivo CSV de centro de utilidad%') as centros_utilidad_csv,
                   count(*) filter (where actividad like '%subcentro de utilidad%' and
                                          actividad not like 'Carga de archivo CSV') as subcentros_utilidad,
                   count(*) filter (where actividad like '%Carga de archivo CSV de subcentro de utilidad%') as subcentros_utilidad_csv,
                   count(*) filter (where actividad like '%centro de costo%' and actividad not like '%suministros por centro de costo%' and
                                          actividad not like '%suministro por centro de costo%' and actividad not like '%mano de obra por centro de costo%' and
                                          actividad not like 'Carga de archivo CSV') as centros_costo,
                   count(*) filter (where actividad like '%Carga de archivo CSV de centros de costo%' and actividad not like '%suministros por centro de costo%' and
                                          actividad not like '%suministro por centro de costo%' and actividad not like '%mano de obra por centro de costo%') as centros_costo_csv,
                   count(*) filter (where (actividad like '%detalle de elementos%' or
                                           actividad like '%detalle de elemento%') and
                                           actividad not like 'Carga de archivo CSV') as detalle_elementos,
                   count(*) filter (where actividad like '%Carga de archivo CSV de detalle de elementos%') as detalle_elementos_csv,
                   count(*) filter (where (actividad like '%cuenta contable%' or
                                           actividad like '%masiva de cuentas%') and
                                           actividad not like 'Carga de archivo CSV') as cuentas_contables,
                   count(*) filter (where actividad like '%Carga de archivo CSV de plan de cuentas%') as cuentas_contables_csv,
                   count(*) filter (where actividad like '%actividad%' and actividad not like 'Carga de archivo CSV') as actividades,
                   count(*) filter (where actividad like '%Carga de archivo CSV de actividades%') as actividades_csv,
                   count(*) filter (where actividad like '%actividades al centro de costo%' and actividad not like 'Carga de archivo CSV') as actividades_centro_costo,
                   count(*) filter (where actividad like '%Carga de archivo CSV de actividades por centro de costo%') as actividades_centro_costo_csv,
                   count(*) filter (where actividad like '%de la base de distribución%' and actividad not like 'Carga de archivo CSV') as bases_distribucion,
                   count(*) filter (where actividad like '%Carga de archivo CSV de bases de distribución%') as bases_distribucion_csv,
                   count(*) filter (where actividad like '%de distribución de costos para el centro%') as distribucion_costos,
                   count(*) filter (where actividad like '%del contrato%' and actividad not like 'Carga de archivo CSV') as contratos,
                   count(*) filter (where actividad like '%Carga de archivo CSV de contratos%') as contratos_csv,
                   count(*) filter (where actividad like '%del grupo de suministros%' and actividad not like 'Carga de archivo CSV') as grupo_suministros,
                   count(*) filter (where actividad like '%Carga de archivo CSV de grupos de suministro%') as grupo_suminsitros_csv,
                   count(*) filter (where actividad like '%cuentas contables a grupo de suministros%' and actividad not like 'Carga de archivo CSV') as relacion_cuentas_contables,
                   count(*) filter (where actividad like '%Carga de archivo CSV de relación de cuentas contables%') as relacion_cuentas_contables_csv,
                   count(*) filter (where actividad like '%del suministro%' and actividad not like '%del suministro por centro de costo%' and actividad not like '%Carga de archivo CSV%') as suministros,
                   count(*) filter (where actividad like '%Carga de archivo CSV de suministros%' and actividad not like '%Carga de archivo CSV de suministros por centro de costo%') as suminsitros_csv,
                   count(*) filter (where actividad like '%del suministro por centro de costo%' and actividad not like 'Carga de archivo CSV') as suministros_centro_costo,
                   count(*) filter (where actividad like '%Carga de archivo CSV de suministros por centro de costo%') as suminsitros_centro_costo_csv,
                   count(*) filter (where actividad like '%de la mano de obra%' and actividad not like '%de la mano de obra por centro de costo%' and actividad not like '%Carga de archivo CSV%') as mano_obra,
                   count(*) filter (where actividad like '%Carga de archivo CSV de mano de obra%' and actividad not like '%Carga de archivo CSV de mano de obra por centro de costo%') as mano_obra_csv,
                   count(*) filter (where actividad like '%de la mano de obra por centro de costo%' and actividad not like '%Carga de archivo CSV%') as mano_obra_centro_costo,
                   count(*) filter (where actividad like '%Carga de archivo CSV de mano de obra por centro de costo%') as mano_obra_centro_costo_csv,
                   count(*) filter (where actividad like '%de recursos directos de la actividad%' and actividad not like '%Carga de archivo CSV%') as rec_directos_actividad,
                   count(*) filter (where actividad like '%Carga de archivo CSV de recursos directos por actividad%') as rec_directos_actividad_csv,
                   count(*) filter (where actividad like '%de las actividades por paquete del paquete%' and actividad not like '%Carga de archivo CSV%') as paquetes,

                   count(*) filter (where actividad like '%Asignación de distribución de costos en el año%' or
					   		              actividad like '%Actulizacion asignación de distribución de costos en el año%') as info_financiera,
                   count(*) filter (where actividad like '%Carga de archivo CSV de información financiera%') as info_financiera_csv,
                   count(*) filter (where actividad like '%Consolidacion de mano de obra en el año%' or
                                          actividad like '%Creación de informacion de mano de obra para el tercero%' or
                                          actividad like '%Actualización de informacion de mano de obra para el tercero%' or
                                          actividad like '%Devolución del tercero%') as info_mano_obra,
                   count(*) filter (where actividad like '%Carga de archivo CSV de información de mano de obra%' or
                                            actividad like '%Carga de archivo CSV de información de costo por cargo%') as info_mano_obra_csv,
                   count(*) filter (where actividad like '%Creación de la infomación de bases de distribución en el año%' or
                                          actividad like '%Actualización de la infomación de bases de distribución%' or
                                          actividad like '%Eliminación de la informacion de base de distribucion%') as info_bases_distribucion,
                   count(*) filter (where actividad like '%Carga de archivo CSV de informacion de bases de distribucion%') as info_bases_distribucion_csv,
                   count(*) filter (where actividad like '%Carga de archivo CSV de información producción%') as info_produccion_csv,
                   count(*) filter (where actividad like '%Eliminación del registro de producción%') as info_produccion_borrar,

                   count(*) filter (where actividad like '%del detalle de suministro%' or
                                          actividad like '%de detalle de suministro%') as detalle_suministros,
                   count(*) filter (where actividad like '%Carga de archivo CSV de detalle de suminsitros%') as detalle_suministros_csv
            from (
                select con_id_contrato as contrato,
                       usu_cuenta as cuenta_usuario,
                       usu_nombre as nombre_usuario,
                       log_descripcion as actividad,
                       loa.created_at as fecha_hora
                from costos_principal.log_actividades as loa
                left join costos_principal.contrato as con on (loa.log_contrato = cast(con.con_pk_id as text))
                left join costos_principal.usuarios as usu on (loa.log_usuario = cast(usu.usu_pk_id as text))
                where log_tipo_accion = 'Programada' and con_id_contrato is not null and usu_cuenta is not null and
                      loa.created_at is not null and cast(loa.created_at as date) >= cast('".$fecha."' as date) and cast(loa.created_at as date) <= cast('".$fechaFin."' as date)
                order by loa.created_at asc
            ) as log
            group by 1,2,3
            order by 1,2,3
        ");
    }
}
