<?php

namespace App\Http\Controllers;

use App\Models\ManoObra;
use App\Models\AvanceModulos;
use Illuminate\Http\Request;

class ManoObraController extends Controller
{
    private $apiKey;

    function __construct() {
        $apiController = new ApiController();

        $this->apiKey = $apiController->getApiKey()["key"];
    }

    public function crearManoObra(Request $request) {
        $id = new \stdClass();

        \DB::transaction(function() use(&$id, $request) {
            $manoObra = ManoObra::on('costos_principal');

            $id = $manoObra->create(
                [
                    "con_fk_id" => $request->input("con_fk_id"),
                    "ins_fk_id" => $request->input("ins_fk_id"),
                    "mob_ano" => $request->input("mob_ano"),
                    "mob_codigo" => $request->input("mob_codigo"),
                    "mob_cargo" => $request->input("mob_cargo")
                ]
            );

            $this->verificarAvance($request->input("con_fk_id"),
                                   $request->input("ins_fk_id"),
                                   $request->input("mob_ano"));
        });

        return array("response" => $id->mob_pk_id);
    }

    public function actualizarManoObra(Request $request) {
        ManoObra::on('costos_principal')
                ->where("mob_pk_id", $request->input("mob_pk_id"))
                ->where("con_fk_id", $request->input("con_fk_id"))
                ->where("ins_fk_id", $request->input("ins_fk_id"))
                ->where("mob_ano", $request->input("mob_ano"))
        ->update(
            [
                "mob_codigo" => $request->input("mob_codigo"),
                "mob_cargo" => $request->input("mob_cargo")
            ]
        );
    }

    public function borrarManoObra(Request $request) {
        \DB::transaction(function() use(&$id, $request) {
            ManoObra::on('costos_principal')
                    ->where("mob_pk_id", $request->input("mob_pk_id"))
                    ->delete();

            $this->verificarAvance($request->input("con_fk_id"),
                                   $request->input("ins_fk_id"),
                                   $request->input("mob_ano"));
        });
    }

    public function verificarCodigoCargo(Request $request) {
        return ManoObra::on('costos_principal')
                       ->where('con_fk_id', $request->input('con_fk_id'))
                       ->where('ins_fk_id', $request->input('ins_fk_id'))
                       ->where('mob_ano', $request->input('mob_ano'))
                       ->where('mob_codigo', $request->input('mob_codigo'))
                       ->count();
    }

    public function getManoObra(Request $request) {
        return ManoObra::on('costos_principal')
                       ->where('con_fk_id', $request->input('con_fk_id'))
                       ->where('ins_fk_id', $request->input('ins_fk_id'))
                       ->where('mob_ano', $request->input('mob_ano'))
                       ->orderBy('mob_cargo')
                       ->get()->toArray();
    }

    public function cargarArchivoManoObra(Request $request) {
        $apiKey = $request->apiKey;

        if ($apiKey === $this->apiKey) {
            $rutaDelArchivo = $request->manoObra->path();
            $delimitador = $request->delimitador;
            $archivo = fopen($rutaDelArchivo, 'r');
            $manoObra = array();
            $primeraLinea = true;

            // Extraer cada línea del archivo CSV y convertirlo en un arreglo
            while($linea = fgetcsv($archivo, 1000, $delimitador)) {
                if (!$primeraLinea) {
                    $registro = $linea;
                    array_push($manoObra, $registro);
                } else {
                    $primeraLinea = false;
                }
            }

            fclose($archivo);

            return $this->procesarArchivoManoObra($manoObra,
                                                  $request->con_fk_id,
                                                  $request->ins_fk_id,
                                                  $request->mob_ano);
        } else {
            throw new \Exception('Imposible completar la petición.');
        }
    }

    private function procesarArchivoManoObra($manoObra, $con_fk_id, $ins_fk_id, $mob_ano) {
        $resultados = new \stdClass();
        $resultados->errores = "";

        \DB::transaction(function() use(&$resultados, $manoObra, $con_fk_id, $ins_fk_id, $mob_ano) {
            if (count($manoObra) === 0) {
                $resultados->correcto = false;
                $resultados->errores = 'El archivo está vacío. ';
                return json_encode($resultados);
            } else if (count($manoObra[0]) !== 2) {
                $resultados->correcto = false;
                $resultados->errores = 'La cantidad de columnas no corresponde. ';
                return json_encode($resultados);
            } else {
                $manoObraBd = ManoObra::on('costos_principal')
                                    ->where('con_fk_id', $con_fk_id)
                                    ->where('ins_fk_id', $ins_fk_id)
                                    ->where('mob_ano', $mob_ano)
                                    ->get()->toArray();

                $manoObraExistente = [];
                $registrosProcesados = 0;

                // Crear las relaciones existentes en la base de datos
                foreach ($manoObraBd as $mobDb) {
                    $manoObraExistente[$mobDb['mob_codigo']] = $mobDb['mob_pk_id'];
                }

                // Errores de los centros de utilidad
                $descripcionLargas = false;
                $camposVacios = false;

                // Revisar el archivo respecto a las relaciones existentes
                foreach($manoObra as $mobCsv) {
                    $codigo = utf8_encode(trim($mobCsv[0]));
                    $cargo = utf8_encode(trim($mobCsv[1]));

                    if ($cargo != "") {
                        // Descripcion largas
                        if (strlen($cargo) <= 100) {
                            // Si no existe la mano de obra
                            if (!isset($manoObraExistente[$codigo])) {
                                $manoObraNuevo = ManoObra::on('costos_principal');

                                $id = $manoObraNuevo->create(
                                    [
                                        "con_fk_id" => $con_fk_id,
                                        "ins_fk_id" => $ins_fk_id,
                                        "mob_ano" => $mob_ano,
                                        "mob_codigo" => $codigo,
                                        "mob_cargo" => $cargo
                                    ]
                                );

                                $registrosProcesados++;

                                $manoObraExistente[$codigo] = $id->mob_pk_id;
                            } else {
                                ManoObra::on('costos_principal')
                                        ->where('con_fk_id', $con_fk_id)
                                        ->where('ins_fk_id', $ins_fk_id)
                                        ->where('mob_ano', $mob_ano)
                                        ->where('mob_codigo', $codigo)
                                ->update(
                                    [
                                        "mob_cargo" => $cargo
                                    ]
                                );

                                $registrosProcesados++;
                            }
                        } else {
                            $descripcionLargas = true;
                        }
                    } else {
                        $camposVacios = true;
                    }
                }

                // Descripciones largas
                if ($descripcionLargas) {
                    $resultados->errores .= "Hay descripciones con más caracteres de los permitidos. El máximo para el codigo son 15 caracteres y
                                            100 caracteres para la descripción del cargo.";
                }

                // Campos vacios
                if ($camposVacios) {
                    if ($resultados->errores !== "") {
                        $resultados->errores .= "-  ";
                    }

                    $resultados->errores .= "Hay campos vacíos.";
                }

                if (!$descripcionLargas && !$camposVacios) {
                    $resultados->correcto = true;
                } else {
                    $resultados->correcto = false;
                }

                $resultados->registros = $registrosProcesados;
            }

            $this->verificarAvance($con_fk_id, $ins_fk_id, $mob_ano);
        });

        return json_encode($resultados);
    }

    public function importarCargos(Request $request) {
        \DB::transaction(function() use($request) {
            $anoActual = $request->input('anoActual');
            $anoImportacion = $request->input('anoImportacion');

            // Se importan todas los cargos que no existan en el año actual
            $cargos = \DB::select("with mob_actual as (
                                       select mob_codigo
                                       from costos_principal.mano_obra
                                       where con_fk_id = ".$request->input('con_fk_id')." and
                                             ins_fk_id = '".$request->input('ins_fk_id')."' and
                                             mob_ano = ".$anoActual."
                                   )
                                   select mob_codigo, mob_cargo
                                   from costos_principal.mano_obra
                                   where con_fk_id = ".$request->input('con_fk_id')." and
                                         ins_fk_id = '".$request->input('ins_fk_id')."' and
                                         mob_ano = ".$anoImportacion." and
                                         mob_codigo not in (select mob_codigo from mob_actual)");

            foreach($cargos as $mob) {
                ManoObra::on('costos_principal')->create(
                    [
                        "con_fk_id" => $request->input('con_fk_id'),
                        "ins_fk_id" => $request->input('ins_fk_id'),
                        "mob_ano" => $anoActual,
                        "mob_codigo" => $mob->mob_codigo,
                        "mob_cargo" => $mob->mob_cargo
                    ]
                );
            }

            $this->verificarAvance($request->input('con_fk_id'),
                                   $request->input('ins_fk_id'),
                                   $anoActual);
        });
    }

    public function verificarAvance($contrato, $institucion, $ano) {
        // Verificar si existe registro del avance
        $conteo = AvanceModulos::on('costos_principal')
                               ->where('con_fk_id', $contrato)
                               ->where('ins_fk_id', $institucion)
                               ->where('avm_ano', $ano)
                               ->whereNull('avm_mes')
                               ->count();

        // Verificar el avance del modulo
        $sum = ManoObra::on('costos_principal')
                       ->where('con_fk_id', $contrato)
                       ->where('ins_fk_id', $institucion)
                       ->where('mob_ano', $ano)
                       ->count();

        if ($conteo > 0) {
            if ($sum > 0) {
                AvanceModulos::on('costos_principal')
                                ->where('con_fk_id', $contrato)
                                ->where('ins_fk_id', $institucion)
                                ->where('avm_ano', $ano)
                                ->where('avm_mes', null)
                ->update(
                    [
                        "avm_mano_obra" => true
                    ]
                );
            } else {
               AvanceModulos::on('costos_principal')
                            ->where('con_fk_id', $contrato)
                            ->where('ins_fk_id', $institucion)
                            ->where('avm_ano', $ano)
                            ->where('avm_mes', null)
                ->update(
                    [
                        "avm_mano_obra" => false
                    ]
                ); 
            }
        } else {
            AvanceModulos::on('costos_principal')
            ->create(
                [
                    "con_fk_id" => $contrato,
                    "ins_fk_id" => $institucion,
                    "avm_ano" => $ano,
                    "avm_mes" => null,
                    "avm_mano_obra" => true
                ]
            );
        }            
    }
}
