<?php

namespace App\Http\Controllers;

use App\Models\RelCucGrSuministros;
use App\Models\GrupoSuministros;
use App\Models\CentrosCosto;
use App\Models\CuentasContables;
use Illuminate\Http\Request;

class RelCucGrSuministrosController extends Controller
{
    private $apiKey;

    function __construct() {
        $apiController = new ApiController();

        $this->apiKey = $apiController->getApiKey()["key"];
    }

    public function crearRelCucGrSuministros(Request $request) {
        $relGrCuc = RelCucGrSuministros::on('costos_principal');
        $relaciones = json_decode($request->input('relaciones'));

        foreach ($relaciones as $relacion) {
            $id = $relGrCuc->create(
                [
                    "con_fk_id" => $request->input("con_fk_id"),
                    "ins_fk_id" => $request->input("ins_fk_id"),
                    "rgc_ano" => $request->input("rgc_ano"),
                    "grs_fk_id" => $request->input("grs_fk_id"),
                    "cco_fk_id" => $relacion->cco_fk_id,
                    "cuc_fk_id" => $relacion->cuc_fk_id
                ]
            );
        }

        return array("response" => 1);
    }

    public function actualizarRelCucGrSuministros(Request $request) {
        RelCucGrSuministros::on('costos_principal')
                           ->where('con_fk_id', $request->input('con_fk_id'))
                           ->where('ins_fk_id', $request->input('ins_fk_id'))
                           ->where('rgc_ano', $request->input('rgc_ano'))
                           ->where('grs_fk_id', $request->input('grs_fk_id'))
                           ->delete();

        $relGrCuc = RelCucGrSuministros::on('costos_principal');
        $relaciones = json_decode($request->input('relaciones'));

        foreach ($relaciones as $relacion) {
            $id = $relGrCuc->create(
                [
                    "con_fk_id" => $request->input("con_fk_id"),
                    "ins_fk_id" => $request->input("ins_fk_id"),
                    "rgc_ano" => $request->input("rgc_ano"),
                    "grs_fk_id" => $request->input("grs_fk_id"),
                    "cco_fk_id" => $relacion->cco_fk_id,
                    "cuc_fk_id" => $relacion->cuc_fk_id
                ]
            );
        }

        return array("response" => 1);
    }

    public function getRelCucGrSuministros(Request $request) {
        return RelCucGrSuministros::on('costos_principal')
                                  ->join('centros_costo', 'cco_pk_id', '=', 'cco_fk_id')
                                  ->join('cuentas_contables', 'cuc_pk_id', '=', 'cuc_fk_id')
                                  ->where('rel_cuc_gr_suministros.con_fk_id', $request->input('con_fk_id'))
                                  ->where('rel_cuc_gr_suministros.ins_fk_id', $request->input('ins_fk_id'))
                                  ->where('rgc_ano', $request->input('rgc_ano'))
                                  ->where('grs_fk_id', $request->input('grs_fk_id'))
                                  ->orderBy('cco_cod_homologado')
                                  ->orderBy('cco_descripcion')
                                  ->orderBy('cuc_cuenta')
                                  ->orderBy('cuc_descripcion')
                                  ->get()->toArray();
    }

    public function getRelCucGrSuministrosCompleto(Request $request) {
        return RelCucGrSuministros::on('costos_principal')
                                  ->join('centros_costo', 'cco_pk_id', '=', 'cco_fk_id')
                                  ->join('cuentas_contables', 'cuc_pk_id', '=', 'cuc_fk_id')
                                  ->join('grupo_suministros', 'grs_pk_id', '=', 'grs_fk_id')
                                  ->where('rel_cuc_gr_suministros.con_fk_id', $request->input('con_fk_id'))
                                  ->where('rel_cuc_gr_suministros.ins_fk_id', $request->input('ins_fk_id'))
                                  ->where('rgc_ano', $request->input('rgc_ano'))
                                  ->orderBy('grs_codigo')
                                  ->orderBy('cco_cod_homologado')
                                  ->orderBy('cco_descripcion')
                                  ->orderBy('cuc_cuenta')
                                  ->orderBy('cuc_descripcion')
                                  ->get()->toArray();
    }

    public function cargarArchivoRelCucGrSuministros(Request $request) {
        $apiKey = $request->apiKey;

        if ($apiKey === $this->apiKey) {
            $rutaDelArchivo = $request->relaciones->path();
            $delimitador = $request->delimitador;
            $archivo = fopen($rutaDelArchivo, 'r');
            $relaciones = array();
            $primeraLinea = true;

            // Extraer cada línea del archivo CSV y convertirlo en un arreglo
            while($linea = fgetcsv($archivo, 1000, $delimitador)) {
                if (!$primeraLinea) {
                    $registro = $linea;
                    array_push($relaciones, $registro);
                } else {
                    $primeraLinea = false;
                }
            }

            fclose($archivo);

            return $this->procesarArchivoRelCucGrSuministros($relaciones,
                                                             $request->con_fk_id,
                                                             $request->ins_fk_id,
                                                             $request->rgc_ano);
        } else {
            throw new \Exception('Imposible completar la petición.');
        }
    }

    private function procesarArchivoRelCucGrSuministros($relaciones, $con_fk_id, $ins_fk_id, $rgc_ano) {
        $resultados = new \stdClass();
        $resultados->errores = "";

        if (count($relaciones) === 0) {
            $resultados->correcto = false;
            $resultados->errores = 'El archivo está vacío. ';
            return json_encode($resultados);
        } else if (count($relaciones[0]) !== 3) {
            $resultados->correcto = false;
            $resultados->errores = 'La cantidad de columnas no corresponde. ';
            return json_encode($resultados);
        } else {
            $grupoSuministrosBd = GrupoSuministros::on('costos_principal')
                                                  ->where('con_fk_id', $con_fk_id)
                                                  ->where('ins_fk_id', $ins_fk_id)
                                                  ->where('grs_ano', $rgc_ano)
                                                  ->get()->toArray();

            $centrosCostoBd = CentrosCosto::on('costos_principal')
                                          ->where('con_fk_id', $con_fk_id)
                                          ->where('ins_fk_id', $ins_fk_id)
                                          ->where('cco_ano', $rgc_ano)
                                          ->get()->toArray();

            $cuentasContablesBd = CuentasContables::on('costos_principal')
                                                  ->where('con_fk_id', $con_fk_id)
                                                  ->where('ins_fk_id', $ins_fk_id)
                                                  ->where('cuc_ano', $rgc_ano)
                                                  ->get()->toArray();

            $relacionesBd = RelCucGrSuministros::on('costos_principal')
                                               ->where('con_fk_id', $con_fk_id)
                                               ->where('ins_fk_id', $ins_fk_id)
                                               ->where('rgc_ano', $rgc_ano)
                                               ->get()->toArray();
                                                  

            $grupoSuministrosExistentes = [];                                                  
            $centrosCostosExistentes = [];
            $cuentasContablesExistentes = [];
            $relacionesExistentes = [];
            $registrosProcesados = 0;

            // Crear las relaciones existentes en la base de datos
            foreach ($grupoSuministrosBd as $grsDb) {
                $grupoSuministrosExistentes[$grsDb['grs_codigo']] = $grsDb['grs_pk_id'];
            }

            foreach ($centrosCostoBd as $ccoDb) {
                $centrosCostoExistentes[$ccoDb['cco_cod_homologado']] = $ccoDb['cco_pk_id'];
            }

            foreach ($cuentasContablesBd as $cucDb) {
                $cuentasContablesExistentes[$cucDb['cuc_cuenta']] = $cucDb['cuc_pk_id'];
            }

            foreach ($relacionesBd as $rgcDb) {
                $relacionesExistentes[$rgcDb['grs_fk_id']][$rgcDb['cco_fk_id']][$rgcDb['cuc_fk_id']] = $rgcDb['rgc_pk_id'];
            }

            // Errores
            $grupoSuministrosInexistentes = "";
            $centrosCostoInexistentes = "";
            $cuentasContablesInexistentes = "";
            $camposVacios = false;

            // Revisar el archivo respecto a las relaciones existentes
            foreach($relaciones as $rgcCsv) {
                $grupoSuministros = trim($rgcCsv[0]);
                $centroCosto = trim($rgcCsv[1]);
                $cuentaContable = trim($rgcCsv[2]);

                if ($grupoSuministros != "" || $centroCosto != "" || $cuentaContable != "") {
                    // Existe el grupo de suministros
                    if (isset($grupoSuministrosExistentes[$grupoSuministros])) {
                        // Existe el centro de costo
                        if (isset($centrosCostoExistentes[$centroCosto])) {
                            // Existe la cuenta contable
                            if (isset($cuentasContablesExistentes[$cuentaContable])) {
                                $grs = $grupoSuministrosExistentes[$grupoSuministros];
                                $cco = $centrosCostoExistentes[$centroCosto];
                                $cuc = $cuentasContablesExistentes[$cuentaContable];

                                // Crear la relacion si no existe
                                if (!isset($relacionesExistentes[$grs][$cco][$cuc])) {
                                    $nuevaRelacion = RelCucGrSuministros::on('costos_principal');

                                    $id = $nuevaRelacion->create(
                                        [
                                            "con_fk_id" => $con_fk_id,
                                            "ins_fk_id" => $ins_fk_id,
                                            "rgc_ano" => $rgc_ano,
                                            "grs_fk_id" => $grs,
                                            "cco_fk_id" => $cco,
                                            "cuc_fk_id" => $cuc
                                        ]
                                    );

                                    $relacionesExistentes[$grs][$cco][$cuc] = $id->rgc_pk_id;
                                }
                            } else {
                                $cuentasContablesInexistentes .= $cuentaContable.", ";
                            }
                        } else {
                            $centrosCostoInexistentes .= $centroCosto.", ";
                        }
                    } else {
                        $grupoSuministrosInexistentes .= $grupoSuministros.", ";
                    }
                } else {
                    $camposVacios = true;
                }

                $registrosProcesados++;
            }

            // Grupos de suministros
            if ($grupoSuministrosInexistentes != "") {
                $grupoSuministrosInexistentes[strlen($grupoSuministrosInexistentes) - 1] = " ";
                $grupoSuministrosInexistentes[strlen($grupoSuministrosInexistentes) - 2] = " ";
                $grupoSuministrosInexistentes = "No existen los siguientes grupos de suministros: ".$grupoSuministrosInexistentes;

                if ($resultados->errores !== "") {
                    $resultados->errores .= "-  ";
                }

                $resultados->errores = $grupoSuministrosInexistentes;
            }

            // Centros de costo
            if ($centrosCostoInexistentes != "") {
                $centrosCostoInexistentes[strlen($centrosCostoInexistentes) - 1] = " ";
                $centrosCostoInexistentes[strlen($centrosCostoInexistentes) - 2] = " ";
                $centrosCostoInexistentes = "No existen los siguientes centros de costo: ".$centrosCostoInexistentes;

                if ($resultados->errores !== "") {
                    $resultados->errores .= "-  ";
                }

                $resultados->errores = $centrosCostoInexistentes;
            }

            // Cuentas contables
            if ($cuentasContablesInexistentes != "") {
                $cuentasContablesInexistentes[strlen($cuentasContablesInexistentes) - 1] = " ";
                $cuentasContablesInexistentes[strlen($cuentasContablesInexistentes) - 2] = " ";
                $cuentasContablesInexistentes = "No existen las siguientes cuentas contables: ".$cuentasContablesInexistentes;

                if ($resultados->errores !== "") {
                    $resultados->errores .= "-  ";
                }

                $resultados->errores = $cuentasContablesInexistentes;
            }

            // Campos vacios
            if ($camposVacios) {
                if ($resultados->errores !== "") {
                    $resultados->errores .= "-  ";
                }

                $resultados->errores .= "Hay campos vacíos. ";
            }

            if (!$camposVacios && $grupoSuministrosInexistentes == "" && $centrosCostoInexistentes == "" && $cuentasContablesInexistentes == "") {
                $resultados->correcto = true;
            } else {
                $resultados->correcto = false;
            }

            $resultados->registros = $registrosProcesados;

            return json_encode($resultados);
        }
    }
}
