<?php

namespace App\Http\Controllers;

use App\Models\Usuarios;
use App\Http\Controllers\RolesController;
use App\Http\Controllers\CorreoController;

use Illuminate\Support\Str;
use Illuminate\Http\Request;

class UsuariosController extends Controller
{

    public function crearUsuario(Request $request) {
        $nuevoUsuario = Usuarios::on('costos_principal');

        $id = $nuevoUsuario->create(
            [
                "con_fk_id" => $request->input("contrato"),
                "ins_fk_id" => $request->input("institucion"),
                "usu_cuenta" => $request->input("usuario"),
                "usu_contrasena" => \Crypt::encryptString($request->input("contrasena")),
                "rol_fk_id" => $request->input("rol"),
                "usu_nombre" => $request->input("nombre"),
                "usu_numero_identificacion" => $request->input("numero_identificacion"),
                "usu_correo_elec" => $request->input("correo"),
                "usu_llave" => \Crypt::encryptString(Str::random(22).date("d").date("m").date("Y")),
                "usu_activo" => $request->input("activo"),
                "created_at" => "now()",
                "updated_at" => "now()"
            ]
        );

        return array("response" => $id->usu_pk_id);
    }

    public function getUsuarioBase(Request $request) {
        $usuario = Usuarios::on('costos_principal')
                           ->where('usu_pk_id', $request->input('usuario'))
                           ->get()->toArray();

        $usuario[0]['usu_contrasena'] = \Crypt::decryptString($usuario[0]['usu_contrasena']);
        
        return $usuario;
    }

    public function getUsuariosPorContrato(Request $request) {
        return Usuarios::on('costos_principal')
                       ->where('con_fk_id', $request->input('contrato'))
                       ->get()->toArray();
    }

    public function getUsuariosPorContratoNoResponsable(Request $request) {
        return Usuarios::on('costos_principal')
                       ->where('con_fk_id', $request->input('contrato'))
                       ->where('ins_fk_id', $request->input('institucion'))
                       ->where('rol_fk_id', '!=', 1)
                       ->get()->toArray();
    }

    public function actualizarUsuario(Request $request) {
        Usuarios::on('costos_principal')
                ->where('usu_pk_id', $request->input("usu_pk_id"))
                ->update(["usu_cuenta" => $request->input("usuario"),
                          "usu_contrasena" => \Crypt::encryptString($request->input("contrasena")),
                          "usu_nombre" => $request->input("nombre"),
                          "usu_numero_identificacion" => $request->input("numero_identificacion"),
                          "usu_correo_elec" => $request->input("correo"),
                          "rol_fk_id" => $request->input("rol"),
                          "usu_activo" => $request->input("activo"),
                          "updated_at" => "now()"]);

        return array("response" => 0);
    }

    public function actualizarInfoBasicaUsuario(Request $request) {
        Usuarios::on('costos_principal')
                ->where('usu_pk_id', $request->input("usuario"))
                ->update(
                    [
                        "usu_nombre" => $request->input("nombre"),
                        "usu_contrasena" => \Crypt::encryptString($request->input("contrasena")),
                        "usu_correo_elec" => $request->input("correo")
                    ]
                );
    }

    public function getUsuarioResponsableEmpresa(Request $request) {
        $contrato = $request->input("contrato");
        $institucion = $request->input("institucion");
        $roles = new RolesController();

        $request2 = new \Illuminate\Http\Request;
        $request2->setMethod('POST');

        return Usuarios::on('costos_principal')
                       ->where('rol_fk_id', json_decode($roles->getRolResponsableEmpresa($request2))->response)
                       ->where('con_fk_id', $contrato)
                       ->where('ins_fk_id', $institucion)->get()->toArray();
    }

    public function getUsuarioResponsableEmpresaSinInstitucion(Request $request) {
        $contrato = $request->input("contrato");
        $institucion = $request->input("institucion");
        $roles = new RolesController();

        $request2 = new \Illuminate\Http\Request;
        $request2->setMethod('POST');

        return Usuarios::on('costos_principal')
                       ->where('rol_fk_id', json_decode($roles->getRolResponsableEmpresa($request2))->response)
                       ->where('con_fk_id', $contrato)
                       ->get()->toArray();
    }

    public function validarUsuario(Request $request) {
        $usuario = $request->input("usuario");
        $contrasena = $request->input("contrasena");

        $usuarioDB = Usuarios::on('costos_principal')
                                ->select('usu_pk_id', 'con_fk_id', 'ins_fk_id', 'usu_cuenta', 'usu_contrasena', 'usu_correo_elec', 'rol_fk_id',
                                         'usu_nombre', 'con_fecha_inicio', 'con_fecha_fin', 'usu_politica', 'usu_nuevas_funcionalidades')
                                ->join('contrato', 'con_fk_id', 'con_pk_id')
                                ->where('usu_cuenta', $usuario)
                                ->where('usu_activo', true);

        // Validar si el usuario existe
        if($usuarioDB->count() && \Crypt::decryptString($usuarioDB->value("usu_contrasena")) == $contrasena) {
            $hoy = strtotime(date("Y-m-d"));
            $fechaContratoIni = strtotime(date($usuarioDB->value("con_fecha_inicio")));
            $fechaContrato = strtotime(date($usuarioDB->value("con_fecha_fin")));

            // Sumar 30 días en segundos
            $fechaContrato5 = strtotime(date($usuarioDB->value("con_fecha_fin"))) + (60*60*24*30);

            $roles = new RolesController();
            $request2 = new \Illuminate\Http\Request();

            $rolAdministrador = json_decode($roles->getRolResponsableEmpresa($request2))->response;
            $rolUsuario = $usuarioDB->value("rol_fk_id");

            // Validar si el contrato está vencido
            if ($hoy <= $fechaContrato5 && $hoy >= $fechaContratoIni) {
                // Crear la llave de inicio de sesion
                $llave = Str::random(22).date("d").date("m").date("Y");

                $idUsuario = $usuarioDB->value("usu_pk_id");

                // Actualizar la llave en el servidor
                $usuarioDB->update(array('usu_llave' => \Crypt::encryptString($llave)));

                $usuarioDBAux = Usuarios::on('costos_principal')
                                        ->select('usu_pk_id', 'con_fk_id', 'ins_fk_id', 'usu_cuenta', 'usu_correo_elec', 'rol_fk_id',
                                                 'usu_nombre', 'con_fecha_inicio', 'con_fecha_fin', 'usu_politica', 'usu_nuevas_funcionalidades')
                                        ->join('contrato', 'con_fk_id', 'con_pk_id')
                                        ->where('usu_pk_id', $idUsuario)
                                        ->get()->toArray()[0];

                // Enviar la llave al usuario
                return json_encode(array("token" => $llave,
                                         "id_usuario" => $usuarioDBAux["usu_pk_id"],
                                         "con_fk_id" => $usuarioDBAux["con_fk_id"],
                                         "ins_fk_id" => $usuarioDBAux["ins_fk_id"],
                                         "cuenta_usuario" => $usuarioDBAux["usu_cuenta"],
                                         "rol_fk_id" => $usuarioDBAux['rol_fk_id'],
                                         "nombre_usuario" => $usuarioDBAux['usu_nombre'],
                                         "correo_usuario" => $usuarioDBAux['usu_correo_elec'],
                                         "politica" => $usuarioDBAux['usu_politica'],
                                         "nuevasFuncionalidades" => $usuarioDBAux['usu_nuevas_funcionalidades']));
            }
            else {
                return json_encode(array("token" => 0));
            }
        }
        else {
            return json_encode(array("token" => 0));
        }
    }

    public function validarTokenUsuario(Request $request) {
        $usuario = $request->input("usuario");
        $token = $request->input("token");

        $usuarioDB = Usuarios::on('costos_principal')
                            ->join('contrato', 'con_fk_id', '=', 'con_pk_id')
                            ->where('usu_cuenta', $usuario);

        if($usuarioDB->count() > 0) {
            $llave = \Crypt::decryptString($usuarioDB->value("usu_llave"));

            if(trim(strval($llave)) != '' && $llave == $token) {
                $hoy = strtotime(date("Y-m-d"));
                $fechaContrato = strtotime(date($usuarioDB->value("con_fecha_fin")));

                // Sumar 5 días en segundos
                $fechaContrato5 = strtotime(date($usuarioDB->value("con_fecha_fin"))) + (60*60*24*30);

                $roles = new RolesController();
                $request2 = new \Illuminate\Http\Request();

                if($hoy <= $fechaContrato5) {
                    return json_encode(array("response" => 1));
                } else {
                    return json_encode(array("response" => 0));
                }
            }
            else {
                return json_encode(array("response" => 0));
            }
        }
        else {
            return json_encode(array("response" => 0));
        }
    }


    public function verificarExistenciaCuenta(Request $request) {
        $usuario = $request->input("usuario");

        return array("response" => Usuarios::on('costos_principal')->where('usu_cuenta', $usuario)->count());
    }

    public function getUsuariosContrato(Request $request) {
        $contrato = $request->input("con_pk_id");

        return Usuarios::on('eas_principal')
                       ->join('roles', 'rol_fk_id', '=', 'rol_pk_id')
                       ->join('estudio', 'est_fk_id', '=', 'est_pk_id')
                       ->join('instituciones_reps', 'ins_fk_id', '=', 'inr_pk_id')
                       ->join('sedes', 'sed_fk_id', '=', 'sed_pk_id')
                       ->where('usuarios.con_fk_id', $contrato)
                       ->orderBy('rol_fk_id', 'DESC')->get()->toArray();
    }

    public function getInstitucionUsuario(Request $request) {
        $institucion = $request->input("institucion");

        return InstitucionesReps::on('costos_principal')
                            ->where('inr_pk_id', $institucion)->get()->toArray();
    }

    public function getSedeUsuario(Request $request) {
        $sede = $request->input("sede");

        return SedesReps::on('costos_principal')
                        ->where('ser_pk_id', $sede)->get()->toArray();
    }

    public function enviarContrasena(Request $request) {
        $usuario = $request->input("usuario");

        $usuarioDB = Usuarios::on('costos_principal')
                            ->where('usu_cuenta', $usuario);

        if ($usuarioDB->count() > 0) {
            $request2 = new \Illuminate\Http\Request;
            $request2->setMethod('POST');
            $request2->request->add(['usuario' => $usuario]);
            $request2->request->add(['contrasena' => \Crypt::decryptString($usuarioDB->value('usu_contrasena'))]);

            $estado = json_decode($this->validarUsuario($request2))->token;

            if ($estado != '0') {
                $correo = new CorreoController();

                $correo->enviarContrasena($usuarioDB->value('usu_correo_elec'),
                                          \Crypt::decryptString($usuarioDB->value('usu_contrasena')));

                return array("response" => 1);
            }
            else {
                return array("response" => 0);
            }
        }

        return array("response" => 0);
    }

    public function aceptarPoliticaProteccionDatos(Request $request) {
        Usuarios::on('costos_principal')
                ->where('usu_pk_id', $request->input('usu_pk_id'))
        ->update(
            [
                "usu_politica" => true,
                "usu_fecha_politica" => "now()"
            ]
        );
    }

    public function aceptarNuevasFuncionalidades(Request $request) {
        Usuarios::on('costos_principal')
                ->where('usu_pk_id', $request->input('usu_pk_id'))
        ->update(
            [
                "usu_nuevas_funcionalidades" => true
            ]
        );
    }

    /* FUNCION ESPECIFICA PARA ACTUALIZACION 2.5.0.0.0 */
    /*public function encriptarContrasenas() {
        $usuarios = Usuarios::on('costos_principal')->get()->toArray();

        foreach ($usuarios as $usu) {
            Usuarios::on('costos_principal')->where('usu_pk_id', $usu['usu_pk_id'])
            ->update(
                [
                    'usu_contrasena' => \Crypt::encryptString($usu['usu_contrasena']),
                    'usu_llave' => \Crypt::encryptString($usu['usu_llave'])
                ]
            );
        }
    }*/
}
