<?php

namespace App\Http\Middleware;

use Closure;
use App\Http\Controllers\ApiController;

class CheckToken
{
    private $apiKey;

    function __construct() {
        $apiController = new ApiController();

        $this->apiKey = $apiController->getApiKey()["key"];
    }

    // Revisar el request hecho por el usuario
    public function handle($request, Closure $next)
    {
        if ($request->input('apiKey') != $this->apiKey) {
            throw new \Exception('Imposible completar la petición.');
        }

        return $next($request);
    }
}
