<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('email')->unique();
            $table->string('email_verif_code')->nullable();
            $table->timestamp('email_verif_code_life')->nullable();
            $table->timestamp('email_verified_at')->nullable();
            $table->string('password', 1000);
            $table->rememberToken();
            $table->timestamps();

            $table->index('email');
            $table->index('email_verif_code');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
    }
}
