<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class Municipios extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('municipios', function (Blueprint $table) {
            $table->integer('mun_pk_id');
            $table->integer('dep_fk_id');
            $table->string('mun_nombre', 70);

            $table->primary('mun_pk_id');
            $table->foreign('dep_fk_id')->references('dep_pk_id')->on('departamentos')->onDelete('cascade');

            $table->index('dep_fk_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('municipios');
    }
}
