<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class Sedes extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sedes', function (Blueprint $table) {
            $table->integer('sed_pk_id');
            $table->integer('con_fk_id');
            $table->string('ins_fk_id', 50);
            $table->string('sed_nombre_sede', 200);
            $table->string('sed_direccion', 300)->nullable();
            $table->integer('dep_fk_id');
            $table->integer('mun_fk_id');

            // Llaves foraneas
            $table->primary(['sed_pk_id', 'con_fk_id']);
            $table->foreign('ins_fk_id')->references('inr_pk_id')->on('instituciones_reps')->onDelete('cascade');
            $table->foreign('con_fk_id')->references('con_pk_id')->on('contrato')->onDelete('cascade');

            $table->index(['con_fk_id', 'ins_fk_id']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sedes');
    }
}
