<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class Usuarios extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('usuarios', function (Blueprint $table) {
            $table->increments('usu_pk_id');
            $table->integer('con_fk_id');
            $table->string('ins_fk_id', 50);
            $table->string('usu_cuenta', 50)->unique();
            $table->string('usu_contrasena', 1000);
            $table->integer('rol_fk_id');
            $table->string('usu_nombre', 80);
            $table->string('usu_numero_identificacion', 30);
            $table->string('usu_correo_elec', 80);
            $table->string('usu_llave', 1000);
            $table->boolean('usu_activo');
            $table->boolean('usu_politica')->default(false);
            $table->date('usu_fecha_politica')->nullable();
            $table->boolean('usu_nuevas_funcionalidades')->default(true);

            $table->timestamps();

            // Llaves foraneas
            $table->foreign('con_fk_id')->references('con_pk_id')->on('contrato')->onDelete('cascade');
            $table->foreign(['ins_fk_id', 'con_fk_id'])->references(['ins_pk_id', 'con_fk_id'])->on('instituciones')->onDelete('cascade');
            $table->foreign('rol_fk_id')->references('rol_pk_id')->on('roles')->onDelete('cascade');

            $table->index('usu_cuenta');
            $table->index(['usu_cuenta', 'usu_activo']);
            $table->index(['con_fk_id', 'ins_fk_id']);
            $table->index('ins_fk_id');
            $table->index('rol_fk_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('usuarios');
    }
}
