<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class HistorialContratos extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('historial_contratos', function (Blueprint $table) {
            $table->increments('hco_pk_id');
            $table->string('hco_id_contrato', 200);
            $table->integer('hco_no_usuarios')->nullable();
            $table->string('hco_nit', 50)->nullable();
            $table->string('hco_razon_social', 250)->nullable();
            $table->string('hco_rep_legal', 200)->nullable();
            $table->string('hco_correo_rep', 200)->nullable();
            $table->string('hco_direccion', 200)->nullable();
            $table->integer('dep_fk_id')->nullable();
            $table->string('hco_ciudad', 200)->nullable();
            $table->date('hco_fecha_inicio')->nullable();
            $table->date('hco_fecha_fin')->nullable();

            // Llaves foraneas
            $table->foreign('dep_fk_id')->references('dep_pk_id')->on('departamentos')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('historial_contratos');
    }
}
