<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CentrosUtilidad extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('centros_utilidad', function (Blueprint $table) {
            $table->increments('cut_pk_id');
            $table->integer('con_fk_id');
            $table->string('ins_fk_id', 50);
            $table->integer('cut_ano');
            $table->string('cut_codigo', 1);
            $table->string('cut_descripcion', 80);

            $table->foreign('con_fk_id')->references('con_pk_id')->on('contrato')->onDelete('cascade');
            $table->foreign(['ins_fk_id', 'con_fk_id'])->references(['ins_pk_id', 'con_fk_id'])->on('instituciones')->onDelete('cascade');

            $table->unique(['con_fk_id', 'ins_fk_id', 'cut_ano', 'cut_codigo']);
            $table->index(['con_fk_id', 'ins_fk_id', 'cut_ano']);
            $table->index(['con_fk_id', 'ins_fk_id', 'cut_codigo']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('centros_utilidad');
    }
}
