<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class SubcentrosUtilidad extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('subcentros_utilidad', function (Blueprint $table) {
            $table->increments('scu_pk_id');
            $table->integer('con_fk_id');
            $table->string('ins_fk_id', 50);
            $table->integer('scu_ano');
            $table->integer('cut_fk_id');
            $table->string('scu_codigo', 2);
            $table->string('scu_descripcion', 80);

            $table->foreign('con_fk_id')->references('con_pk_id')->on('contrato')->onDelete('cascade');
            $table->foreign(['ins_fk_id', 'con_fk_id'])->references(['ins_pk_id', 'con_fk_id'])->on('instituciones')->onDelete('cascade');
            $table->foreign('cut_fk_id')->references('cut_pk_id')->on('centros_utilidad')->onDelete('cascade');

            $table->unique(['con_fk_id', 'ins_fk_id', 'scu_ano', 'cut_fk_id', 'scu_codigo']);
            $table->index(['con_fk_id', 'ins_fk_id', 'scu_ano']);
            $table->index(['con_fk_id', 'ins_fk_id', 'scu_ano', 'scu_codigo']);
            $table->index('cut_fk_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('subcentros_utilidad');
    }
}
