<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CentrosCosto extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('centros_costo', function (Blueprint $table) {
            $table->increments('cco_pk_id');
            $table->integer('con_fk_id');
            $table->string('ins_fk_id', 50);
            $table->integer('sed_fk_id');
            $table->integer('cco_ano');
            $table->integer('cut_fk_id');
            $table->integer('scu_fk_id');
            $table->string('cco_codigo', 3);
            $table->string('cco_codigo_completo', 6);
            $table->string('cco_cod_homologado', 20);
            $table->string('cco_descripcion', 80);
            $table->boolean('cco_final');
            $table->string('cco_unidad_medida', 80);
            $table->boolean('cco_activo')->default(true);
            $table->date('cco_fecha_inac')->nullable();

            $table->foreign('con_fk_id')->references('con_pk_id')->on('contrato')->onDelete('cascade');
            $table->foreign(['ins_fk_id', 'con_fk_id'])->references(['ins_pk_id', 'con_fk_id'])->on('instituciones')->onDelete('cascade');
            $table->foreign(['sed_fk_id', 'con_fk_id'])->references(['sed_pk_id', 'con_fk_id'])->on('sedes')->onDelete('cascade');
            $table->foreign('cut_fk_id')->references('cut_pk_id')->on('centros_utilidad')->onDelete('cascade');
            $table->foreign('scu_fk_id')->references('scu_pk_id')->on('subcentros_utilidad')->onDelete('cascade');

            $table->unique(['con_fk_id', 'ins_fk_id', 'sed_fk_id', 'cco_ano', 'cut_fk_id', 'scu_fk_id', 'cco_codigo']);
            $table->index(['con_fk_id', 'ins_fk_id', 'cco_ano']);
            $table->index(['con_fk_id', 'ins_fk_id', 'cco_ano', 'sed_fk_id']);
            $table->index(['con_fk_id', 'ins_fk_id', 'cco_ano', 'cco_cod_homologado']);
            $table->index('cut_fk_id');
            $table->index('scu_fk_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('centros_costo');
    }
}
