<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class DetalleElementos extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('detalle_elementos', function (Blueprint $table) {
            $table->increments('del_pk_id');
            $table->integer('con_fk_id');
            $table->string('ins_fk_id', 50);
            $table->integer('del_ano');
            $table->integer('elm_fk_id');
            $table->string('del_descripcion', 80);
            $table->boolean('del_activo')->default(true);
            $table->date('del_fecha_inac')->nullable();

            $table->foreign('con_fk_id')->references('con_pk_id')->on('contrato')->onDelete('cascade');
            $table->foreign(['ins_fk_id', 'con_fk_id'])->references(['ins_pk_id', 'con_fk_id'])->on('instituciones')->onDelete('cascade');
            $table->foreign('elm_fk_id')->references('elm_pk_id')->on('elementos')->onDelete('cascade');

            $table->index(['con_fk_id', 'ins_fk_id', 'del_ano']);
            $table->index('elm_fk_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('detalle_elementos');
    }
}
