<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CuentasContables extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('cuentas_contables', function (Blueprint $table) {
            $table->increments('cuc_pk_id');
            $table->integer('con_fk_id');
            $table->string('ins_fk_id', 50);
            $table->integer('cuc_ano');
            $table->string('cuc_cuenta', 15);
            $table->string('cuc_descripcion', 80);
            $table->integer('nac_fk_id');
            $table->integer('elm_fk_id')->nullable();
            $table->integer('del_fk_id')->nullable();
            $table->integer('tre_fk_id')->nullable();
            $table->integer('cre_fk_id')->nullable();
            $table->boolean('cuc_activo')->default(true);
            $table->date('cuc_fecha_inac')->nullable();

            $table->foreign('con_fk_id')->references('con_pk_id')->on('contrato')->onDelete('cascade');
            $table->foreign(['ins_fk_id', 'con_fk_id'])->references(['ins_pk_id', 'con_fk_id'])->on('instituciones')->onDelete('cascade');
            $table->foreign('nac_fk_id')->references('nac_pk_id')->on('naturaleza_cuenta')->onDelete('cascade');
            $table->foreign('elm_fk_id')->references('elm_pk_id')->on('elementos')->onDelete('cascade');
            $table->foreign('del_fk_id')->references('del_pk_id')->on('detalle_elementos')->onDelete('cascade');
            $table->foreign('tre_fk_id')->references('tre_pk_id')->on('tipo_recurso')->onDelete('cascade');
            $table->foreign('cre_fk_id')->references('cre_pk_id')->on('caracter_recurso')->onDelete('cascade');

            $table->unique(['con_fk_id', 'ins_fk_id', 'cuc_ano', 'cuc_cuenta']);
            $table->index(['con_fk_id', 'ins_fk_id', 'cuc_ano']);
            $table->index(['con_fk_id', 'ins_fk_id', 'cuc_ano', 'cuc_cuenta']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cuentas_contables');
    }
}
