<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class BasesDistribucion extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('bases_distribucion', function (Blueprint $table) {
            $table->increments('bdi_pk_id');
            $table->integer('con_fk_id')->nullable();
            $table->string('ins_fk_id', 50)->nullable();
            $table->integer('bdi_ano')->nullable();
            $table->string('bdi_codigo', 30);
            $table->string('bdi_descripcion', 150);
            $table->boolean('bdi_predefinida');
            $table->boolean('bdi_mano_obra')->default(false);
            $table->boolean('bdi_activo')->default(true);
            $table->date('bdi_fecha_inac')->nullable();

            $table->foreign('con_fk_id')->references('con_pk_id')->on('contrato')->onDelete('cascade');
            $table->foreign(['ins_fk_id', 'con_fk_id'])->references(['ins_pk_id', 'con_fk_id'])->on('instituciones')->onDelete('cascade');

            $table->unique(['con_fk_id', 'ins_fk_id', 'bdi_ano', 'bdi_codigo']);
            $table->index(['con_fk_id', 'ins_fk_id', 'bdi_ano']);
            $table->index(['con_fk_id', 'ins_fk_id', 'bdi_ano', 'bdi_codigo']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('bases_distribucion');
    }
}
