<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class Suministros extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('suministros', function (Blueprint $table) {
            $table->increments('sum_pk_id');
            $table->integer('con_fk_id');
            $table->string('ins_fk_id', 50);
            $table->integer('sum_ano');
            $table->integer('grs_fk_id');
            $table->string('sum_codigo', 25);
            $table->string('sum_nombre', 300);
            $table->string('sum_unidad_medida', 80);
            $table->boolean('sum_activo')->default(true);
            $table->date('sum_fecha_inac')->nullable();

            $table->foreign('con_fk_id')->references('con_pk_id')->on('contrato')->onDelete('cascade');
            $table->foreign(['ins_fk_id', 'con_fk_id'])->references(['ins_pk_id', 'con_fk_id'])->on('instituciones')->onDelete('cascade');
            $table->foreign('grs_fk_id')->references('grs_pk_id')->on('grupo_suministros')->onDelete('cascade');

            $table->unique(['con_fk_id', 'ins_fk_id', 'sum_ano', 'grs_fk_id', 'sum_codigo']);
            $table->index(['sum_ano', 'con_fk_id', 'ins_fk_id', 'grs_fk_id', 'sum_codigo']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('suministros');
    }
}
