<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class DistribucionCostosCentros extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('distribucion_costos_centros', function (Blueprint $table) {
            $table->increments('dco_pk_id');
            $table->integer('con_fk_id');
            $table->string('ins_fk_id', 50);
            $table->integer('dco_ano');
            $table->integer('dco_centro_no_final');
            $table->integer('dco_centro_final');

            $table->foreign('con_fk_id')->references('con_pk_id')->on('contrato')->onDelete('cascade');
            $table->foreign(['ins_fk_id', 'con_fk_id'])->references(['ins_pk_id', 'con_fk_id'])->on('instituciones')->onDelete('cascade');
            $table->foreign('dco_centro_no_final')->references('cco_pk_id')->on('centros_costo')->onDelete('cascade');
            $table->foreign('dco_centro_final')->references('cco_pk_id')->on('centros_costo')->onDelete('cascade');

            $table->unique(['con_fk_id', 'ins_fk_id', 'dco_ano', 'dco_centro_no_final', 'dco_centro_final']);
            $table->index(['con_fk_id', 'ins_fk_id', 'dco_ano'], 'dco_index1');
            $table->index(['con_fk_id', 'ins_fk_id', 'dco_ano', 'dco_centro_no_final'], 'dco_index2');
            $table->index('dco_centro_no_final');
            $table->index('dco_centro_final');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('distribucion_costos_centros');
    }
}
