<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class ManoObra extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('mano_obra', function (Blueprint $table) {
            $table->increments('mob_pk_id');
            $table->integer('con_fk_id');
            $table->string('ins_fk_id', 50);
            $table->integer('mob_ano');
            $table->string('mob_codigo', 30);
            $table->string('mob_cargo', 100);
            $table->boolean('mob_activo')->default(true);
            $table->date('mob_fecha_inac')->nullable();

            $table->foreign('con_fk_id')->references('con_pk_id')->on('contrato')->onDelete('cascade');
            $table->foreign(['ins_fk_id', 'con_fk_id'])->references(['ins_pk_id', 'con_fk_id'])->on('instituciones')->onDelete('cascade');

            $table->index(['con_fk_id', 'ins_fk_id', 'mob_ano']);
            $table->index(['con_fk_id', 'ins_fk_id', 'mob_ano', 'mob_codigo']);

            $table->unique(['con_fk_id', 'ins_fk_id', 'mob_ano', 'mob_codigo']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('mano_obra');
    }
}
