<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class RecActividadManoObra extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('rec_actividad_mano_obra', function (Blueprint $table) {
            $table->increments('ram_pk_id');
            $table->integer('con_fk_id');
            $table->string('ins_fk_id', 50);
            $table->integer('ram_ano');
            $table->integer('cco_fk_id');
            $table->integer('act_fk_id');
            $table->integer('mob_fk_id');
            $table->string('ram_unidad_medida', 80)->nullable();
            $table->string('ram_unidad_consumo', 80)->nullable();
            $table->float('ram_relacion')->nullable();
            $table->float('ram_factor_conversion')->nullable();
            $table->float('ram_consumo_actividad')->nullable();
            $table->float('ram_valor_actividad')->nullable();

            $table->foreign('con_fk_id')->references('con_pk_id')->on('contrato')->onDelete('cascade');
            $table->foreign(['ins_fk_id', 'con_fk_id'])->references(['ins_pk_id', 'con_fk_id'])->on('instituciones')->onDelete('cascade');
            $table->foreign('cco_fk_id')->references('cco_pk_id')->on('centros_costo')->onDelete('cascade');
            $table->foreign('act_fk_id')->references('act_pk_id')->on('actividades')->onDelete('cascade');
            $table->foreign('mob_fk_id')->references('mob_pk_id')->on('mano_obra')->onDelete('cascade');

            $table->index(['ins_fk_id', 'cco_fk_id', 'ram_ano'], 'ram_index1');
            $table->index(['ins_fk_id', 'cco_fk_id', 'ram_ano', 'act_fk_id'], 'ram_index2');
            $table->index(['ins_fk_id', 'cco_fk_id', 'ram_ano', 'act_fk_id', 'mob_fk_id'], 'ram_index3');

            $table->unique(['con_fk_id', 'ins_fk_id', 'ram_ano', 'cco_fk_id', 'act_fk_id', 'mob_fk_id']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('rec_actividad_mano_obra');
    }
}
