<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class SedesProgramas extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sedes_programas', function (Blueprint $table) {
            $table->bigIncrements('sep_pk_id');
            $table->integer('con_fk_id');
            $table->string('ins_fk_id', 50);
            $table->integer('sep_ano');
            $table->bigInteger('prg_fk_id');
            $table->integer('sed_fk_id');
            $table->boolean('sep_asignado')->default(false);

            $table->foreign('con_fk_id')->references('con_pk_id')->on('contrato')->onDelete('cascade');
            $table->foreign(['ins_fk_id', 'con_fk_id'])->references(['ins_pk_id', 'con_fk_id'])->on('instituciones')->onDelete('cascade');
            $table->foreign('prg_fk_id')->references('prg_pk_id')->on('programas')->onDelete('cascade');
            $table->foreign(['sed_fk_id', 'con_fk_id'])->references(['sed_pk_id', 'con_fk_id'])->on('sedes')->onDelete('cascade');

            $table->index('prg_fk_id', 'sep_index1');
            $table->index(['prg_fk_id', 'sed_fk_id'], 'sep_index2');
            $table->index(['con_fk_id', 'ins_fk_id', 'prg_fk_id', 'sed_fk_id'], 'sep_index3');
            $table->index(['con_fk_id', 'ins_fk_id', 'prg_fk_id'], 'sep_index4');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sedes_programas');
    }
}
