<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class EstadiosProgramas extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('estadios_programas', function (Blueprint $table) {
            $table->bigIncrements('esp_pk_id');
            $table->integer('con_fk_id');
            $table->string('ins_fk_id', 50);
            $table->integer('esp_ano');
            $table->bigInteger('prg_fk_id');
            $table->string('esp_codigo', 10);
            $table->string('esp_descripcion', 500);

            $table->foreign('con_fk_id')->references('con_pk_id')->on('contrato')->onDelete('cascade');
            $table->foreign(['ins_fk_id', 'con_fk_id'])->references(['ins_pk_id', 'con_fk_id'])->on('instituciones')->onDelete('cascade');
            $table->foreign('prg_fk_id')->references('prg_pk_id')->on('programas')->onDelete('cascade');

            $table->index('prg_fk_id', 'esp_index1');
            $table->index(['prg_fk_id', 'esp_codigo'], 'esp_index2');
            $table->index(['con_fk_id', 'ins_fk_id', 'esp_ano', 'prg_fk_id', 'esp_codigo'], 'esp_index3');
            $table->index(['con_fk_id', 'ins_fk_id', 'esp_ano', 'prg_fk_id'], 'esp_index4');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('estadios_programas');
    }
}
