<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class ActividadesProgramas extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('actividades_programas', function (Blueprint $table) {
            $table->bigIncrements('acp_pk_id');
            $table->integer('con_fk_id');
            $table->string('ins_fk_id', 50);
            $table->integer('acp_ano');
            $table->bigInteger('prg_fk_id');
            $table->bigInteger('sep_fk_id');
            $table->bigInteger('esp_fk_id');
            $table->integer('cco_fk_id');
            $table->integer('act_fk_id');
            $table->integer('acp_cantidad');
            $table->integer('acp_periodicidad');

            $table->foreign('con_fk_id')->references('con_pk_id')->on('contrato')->onDelete('cascade');
            $table->foreign(['ins_fk_id', 'con_fk_id'])->references(['ins_pk_id', 'con_fk_id'])->on('instituciones')->onDelete('cascade');
            $table->foreign('prg_fk_id')->references('prg_pk_id')->on('programas')->onDelete('cascade');
            $table->foreign('sep_fk_id')->references('sep_pk_id')->on('sedes_programas')->onDelete('cascade');
            $table->foreign('esp_fk_id')->references('esp_pk_id')->on('estadios_programas')->onDelete('cascade');
            $table->foreign('cco_fk_id')->references('cco_pk_id')->on('centros_costo')->onDelete('cascade');
            $table->foreign('act_fk_id')->references('act_pk_id')->on('actividades')->onDelete('cascade');

            $table->index('prg_fk_id', 'acp_index1');
            $table->index('sep_fk_id', 'acp_index8');
            $table->index('esp_fk_id', 'acp_index2');
            $table->index('cco_fk_id', 'acp_index3');
            $table->index('act_fk_id', 'acp_index4');
            $table->index(['cco_fk_id', 'act_fk_id'], 'acp_index5');
            $table->index(['con_fk_id', 'ins_fk_id', 'acp_ano', 'prg_fk_id', 'sep_fk_id', 'esp_fk_id', 'cco_fk_id', 'act_fk_id'], 'acp_index6');
            $table->index(['con_fk_id', 'ins_fk_id', 'acp_ano', 'cco_fk_id', 'act_fk_id'], 'acp_index7');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('actividades_programas');
    }
}
