<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class SuministrosProgramas extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('suministros_programas', function (Blueprint $table) {
            $table->bigIncrements('sup_pk_id');
            $table->integer('con_fk_id');
            $table->string('ins_fk_id', 50);
            $table->integer('sup_ano');
            $table->bigInteger('prg_fk_id');
            $table->bigInteger('sep_fk_id');
            $table->bigInteger('esp_fk_id');
            $table->integer('grs_fk_id');
            $table->integer('sum_fk_id');
            $table->integer('sup_cantidad');
            $table->integer('sup_periodicidad');

            $table->foreign('con_fk_id')->references('con_pk_id')->on('contrato')->onDelete('cascade');
            $table->foreign(['ins_fk_id', 'con_fk_id'])->references(['ins_pk_id', 'con_fk_id'])->on('instituciones')->onDelete('cascade');
            $table->foreign('prg_fk_id')->references('prg_pk_id')->on('programas')->onDelete('cascade');
            $table->foreign('sep_fk_id')->references('sep_pk_id')->on('sedes_programas')->onDelete('cascade');
            $table->foreign('esp_fk_id')->references('esp_pk_id')->on('estadios_programas')->onDelete('cascade');
            $table->foreign('grs_fk_id')->references('grs_pk_id')->on('grupo_suministros')->onDelete('cascade');
            $table->foreign('sum_fk_id')->references('sum_pk_id')->on('suministros')->onDelete('cascade');

            $table->index('prg_fk_id', 'sup_index1');
            $table->index('sep_fk_id', 'sup_index5');
            $table->index('esp_fk_id', 'sup_index2');
            $table->index('sum_fk_id', 'sup_index3');
            $table->index(['con_fk_id', 'ins_fk_id', 'sup_ano', 'prg_fk_id', 'sep_fk_id', 'esp_fk_id', 'sum_fk_id'], 'sup_index4');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('suministros_programas');
    }
}
