<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class PaquetesProgramas extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('paquetes_programas', function (Blueprint $table) {
            $table->bigIncrements('pap_pk_id');
            $table->integer('con_fk_id');
            $table->string('ins_fk_id', 50);
            $table->integer('pap_ano');
            $table->bigInteger('prg_fk_id');
            $table->bigInteger('sep_fk_id');
            $table->bigInteger('esp_fk_id');
            $table->integer('act_fk_id');
            $table->integer('pap_cantidad');
            $table->integer('pap_periodicidad');

            $table->foreign('con_fk_id')->references('con_pk_id')->on('contrato')->onDelete('cascade');
            $table->foreign(['ins_fk_id', 'con_fk_id'])->references(['ins_pk_id', 'con_fk_id'])->on('instituciones')->onDelete('cascade');
            $table->foreign('prg_fk_id')->references('prg_pk_id')->on('programas')->onDelete('cascade');
            $table->foreign('sep_fk_id')->references('sep_pk_id')->on('sedes_programas')->onDelete('cascade');
            $table->foreign('esp_fk_id')->references('esp_pk_id')->on('estadios_programas')->onDelete('cascade');
            $table->foreign('act_fk_id')->references('act_pk_id')->on('actividades')->onDelete('cascade');

            $table->index('prg_fk_id', 'pap_index1');
            $table->index('sep_fk_id', 'pap_index5');
            $table->index('esp_fk_id', 'pap_index2');
            $table->index('act_fk_id', 'pap_index3');
            $table->index(['con_fk_id', 'ins_fk_id', 'pap_ano', 'prg_fk_id', 'sep_fk_id', 'esp_fk_id', 'act_fk_id'], 'pap_index4');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('paquetes_programas');
    }
}
