<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class InformacionFinanciera extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('informacion_financiera', function (Blueprint $table) {
            $table->bigIncrements('ifm_pk_id');
            $table->integer('con_fk_id');
            $table->string('ins_fk_id', 50);
            $table->integer('ifm_ano');
            $table->integer('ifm_mes');
            $table->integer('cuc_fk_id');
            $table->string('ifm_nit_tercero', 20);
            $table->string('ifm_razon_social', 500);
            $table->string('ifm_detalle_movimiento', 300)->nullable();
            $table->float('ifm_debito', 20, 5);
            $table->float('ifm_credito', 20, 5);
            $table->float('ifm_valor', 20, 5);
            $table->boolean('ifm_preasignado')->default(false);
            $table->boolean('ifm_asignado')->default(false);
            $table->boolean('ifm_mano_obra')->default(false);

            $table->foreign('con_fk_id')->references('con_pk_id')->on('contrato')->onDelete('cascade');
            $table->foreign(['ins_fk_id', 'con_fk_id'])->references(['ins_pk_id', 'con_fk_id'])->on('instituciones')->onDelete('cascade');
            $table->foreign('cuc_fk_id')->references('cuc_pk_id')->on('cuentas_contables')->onDelete('cascade');

            $table->index(['con_fk_id', 'ins_fk_id', 'ifm_ano', 'ifm_mes']);
            $table->index(['cuc_fk_id']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('informacion_financiera');
    }
}
