<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class InformacionBasesDistribucion2 extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('informacion_bases_distribucion2', function (Blueprint $table) {
            $table->increments('ibd2_pk_id');
            $table->integer('con_fk_id');
            $table->string('ins_fk_id', 50);
            $table->integer('ibd2_ano');
            $table->integer('ibd2_mes');
            $table->integer('cco_fk_id');
            $table->integer('bdi_fk_id');
            $table->float('ibd2_valor');
            $table->boolean('ibd2_automatico')->default(false);

            $table->foreign('con_fk_id')->references('con_pk_id')->on('contrato')->onDelete('cascade');
            $table->foreign(['ins_fk_id', 'con_fk_id'])->references(['ins_pk_id', 'con_fk_id'])->on('instituciones')->onDelete('cascade');
            $table->foreign('cco_fk_id')->references('cco_pk_id')->on('centros_costo')->onDelete('cascade');
            $table->foreign('bdi_fk_id')->references('bdi_pk_id')->on('bases_distribucion')->onDelete('cascade');

            $table->index(['con_fk_id', 'ins_fk_id', 'ibd2_ano', 'ibd2_mes'], 'ibd2_index1');
            $table->index(['con_fk_id', 'ins_fk_id', 'ibd2_ano', 'ibd2_mes', 'cco_fk_id'], 'ibd2_index2');

            $table->unique(['con_fk_id', 'ins_fk_id', 'ibd2_ano', 'ibd2_mes', 'cco_fk_id', 'bdi_fk_id']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('informacion_bases_distribucion2');
    }
}
