<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class RecursosCentroCostoMob extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('recursos_centro_costo_mob', function (Blueprint $table) {
            $table->increments('rcc_pk_id');
            $table->integer('con_fk_id');
            $table->string('ins_fk_id', 50);
            $table->integer('rcc_ano');
            $table->integer('rcc_mes');
            $table->integer('cuc_fk_id');
            $table->integer('elm_fk_id');
            $table->integer('tre_fk_id');
            $table->integer('cre_fk_id');
            $table->integer('cco_fk_id');
            $table->float('rcc_valor');

            $table->foreign('con_fk_id')->references('con_pk_id')->on('contrato')->onDelete('cascade');
            $table->foreign(['ins_fk_id', 'con_fk_id'])->references(['ins_pk_id', 'con_fk_id'])->on('instituciones')->onDelete('cascade');
            $table->foreign('cuc_fk_id')->references('cuc_pk_id')->on('cuentas_contables')->onDelete('cascade');
            $table->foreign('elm_fk_id')->references('elm_pk_id')->on('elementos')->onDelete('cascade');
            $table->foreign('tre_fk_id')->references('tre_pk_id')->on('tipo_recurso')->onDelete('cascade');
            $table->foreign('cre_fk_id')->references('cre_pk_id')->on('caracter_recurso')->onDelete('cascade');
            $table->foreign('cco_fk_id')->references('cco_pk_id')->on('centros_costo')->onDelete('cascade');

            $table->unique(['con_fk_id', 'ins_fk_id', 'rcc_ano', 'rcc_mes', 'cuc_fk_id', 'cco_fk_id']);

            $table->index(['con_fk_id', 'ins_fk_id', 'rcc_ano', 'rcc_mes'], 'rcc_index1');
            $table->index(['con_fk_id', 'ins_fk_id', 'rcc_ano', 'rcc_mes', 'cco_fk_id'], 'rcc_index2');
            $table->index(['elm_fk_id']);
            $table->index(['tre_fk_id']);
            $table->index(['cre_fk_id']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('recursos_centro_costo_mob');
    }
}
