<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class ContratosEps extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('contratos_eps', function (Blueprint $table) {
            $table->increments('coe_pk_id');
            $table->integer('con_fk_id');
            $table->string('ins_fk_id', 50);
            $table->integer('coe_ano');
            $table->string('coe_nit_eps', 20);
            $table->string('coe_nombre_eps', 150);
            $table->integer('reg_fk_id');
            $table->string('coe_numero_contrato', 30);
            $table->bigInteger('coe_monto_anual');
            $table->bigInteger('coe_monto_mensual');
            $table->integer('coe_duracion_contrato');
            $table->integer('coe_pob_asociada');
            $table->boolean('coe_activo')->default(true);

            $table->foreign('con_fk_id')->references('con_pk_id')->on('contrato')->onDelete('cascade');
            $table->foreign(['ins_fk_id', 'con_fk_id'])->references(['ins_pk_id', 'con_fk_id'])->on('instituciones')->onDelete('cascade');
            $table->foreign('reg_fk_id')->references('reg_pk_id')->on('regimen')->onDelete('cascade');

            $table->unique(['con_fk_id', 'ins_fk_id', 'coe_numero_contrato']);

            $table->index(['con_fk_id', 'ins_fk_id', 'coe_ano']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('contratos_eps');
    }
}
