<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class InformacionProduccion extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('informacion_produccion', function (Blueprint $table) {
            $table->increments('ipr_pk_id');
            $table->integer('con_fk_id');
            $table->string('ins_fk_id', 50);
            $table->integer('ipr_ano');
            $table->integer('ipr_mes');
            $table->integer('cco_fk_id');
            $table->integer('act_fk_id')->nullable();
            $table->integer('sum_fk_id')->nullable();
            $table->integer('coe_fk_id');
            $table->bigInteger('prg_fk_id')->nullable();
            $table->bigInteger('esp_fk_id')->nullable();
            $table->float('ipr_cantidad');
            $table->float('ipr_valor')->nullable();
            $table->boolean('ipr_actividad');

            $table->foreign('con_fk_id')->references('con_pk_id')->on('contrato')->onDelete('cascade');
            $table->foreign(['ins_fk_id', 'con_fk_id'])->references(['ins_pk_id', 'con_fk_id'])->on('instituciones')->onDelete('cascade');
            $table->foreign('cco_fk_id')->references('cco_pk_id')->on('centros_costo')->onDelete('cascade');
            $table->foreign('act_fk_id')->references('act_pk_id')->on('actividades')->onDelete('cascade');
            $table->foreign('sum_fk_id')->references('sum_pk_id')->on('suministros')->onDelete('cascade');
            $table->foreign('coe_fk_id')->references('coe_pk_id')->on('contratos_eps')->onDelete('cascade');
            $table->foreign('prg_fk_id')->references('prg_pk_id')->on('programas')->onDelete('cascade');
            $table->foreign('esp_fk_id')->references('esp_pk_id')->on('estadios_programa')->onDelete('cascade');

            $table->index(['con_fk_id', 'ins_fk_id', 'ipr_ano', 'ipr_mes'], 'ipr_index1');
            $table->index(['con_fk_id', 'ins_fk_id', 'ipr_ano', 'ipr_mes', 'coe_fk_id'], 'ipr_index2');
            $table->index(['con_fk_id', 'ins_fk_id', 'ipr_ano', 'ipr_mes', 'cco_fk_id', 'act_fk_id'], 'ipr_index3');
            $table->index(['con_fk_id', 'ins_fk_id', 'ipr_ano', 'ipr_mes', 'cco_fk_id', 'sum_fk_id'], 'ipr_index4');
            $table->index('coe_fk_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('informacion_produccion');
    }
}
