<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CostoTotal extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('costo_total', function (Blueprint $table) {
            $table->increments('cot_pk_id');
            $table->integer('con_fk_id');
            $table->string('ins_fk_id', 50);
            $table->integer('cot_ano');
            $table->integer('cot_mes');
            $table->integer('cco_fk_id');
            $table->float('cot_cp_fijo');
            $table->float('cot_cp_variable');
            $table->float('cot_cp_directo');
            $table->float('cot_cp_indirecto');
            $table->float('cot_cp_total');
            $table->float('cot_cd_fijo');
            $table->float('cot_cd_variable');
            $table->float('cot_cd_directo');
            $table->float('cot_cd_indirecto');
            $table->float('cot_dist_total');
            $table->float('cot_costo_fijo_total');
            $table->float('cot_costo_variable_total');
            $table->float('cot_costo_directo_total');
            $table->float('cot_costo_indirecto_total');
            $table->float('cot_costo_total');

            $table->foreign('con_fk_id')->references('con_pk_id')->on('contrato')->onDelete('cascade');
            $table->foreign(['ins_fk_id', 'con_fk_id'])->references(['ins_pk_id', 'con_fk_id'])->on('instituciones')->onDelete('cascade');
            $table->foreign('cco_fk_id')->references('cco_pk_id')->on('centros_costo')->onDelete('cascade');

            $table->unique(['con_fk_id', 'ins_fk_id', 'cot_ano', 'cot_mes', 'cco_fk_id']);

            $table->index(['con_fk_id', 'ins_fk_id', 'cot_ano', 'cot_mes']);
            $table->index(['con_fk_id', 'ins_fk_id', 'cot_ano', 'cot_mes', 'cco_fk_id']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('costo_total');
    }
}
