<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CostoDistribuido extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('costo_distribuido', function (Blueprint $table) {
            $table->increments('cod_pk_id');
            $table->integer('con_fk_id');
            $table->string('ins_fk_id', 50);
            $table->integer('cod_ano');
            $table->integer('cod_mes');
            $table->integer('cod_cco_no_final');
            $table->float('cod_costo_primario');
            $table->integer('cod_cco_final');
            $table->float('cod_costo_fijo_dist');
            $table->float('cod_costo_variable_dist');
            $table->float('cod_costo_directo_dist');
            $table->float('cod_costo_indirecto_dist');
            $table->float('cod_costo_dist_total');

            $table->foreign('con_fk_id')->references('con_pk_id')->on('contrato')->onDelete('cascade');
            $table->foreign(['ins_fk_id', 'con_fk_id'])->references(['ins_pk_id', 'con_fk_id'])->on('instituciones')->onDelete('cascade');
            $table->foreign('cod_cco_no_final')->references('cco_pk_id')->on('centros_costo')->onDelete('cascade');
            $table->foreign('cod_cco_final')->references('cco_pk_id')->on('centros_costo')->onDelete('cascade');

            $table->unique(['con_fk_id', 'ins_fk_id', 'cod_ano', 'cod_mes', 'cod_cco_no_final', 'cod_cco_final']);

            $table->index(['con_fk_id', 'ins_fk_id', 'cod_ano', 'cod_mes', 'cod_cco_no_final'], 'cod_index1');
            $table->index(['con_fk_id', 'ins_fk_id', 'cod_ano', 'cod_mes', 'cod_cco_no_final', 'cod_cco_final'], 'cod_index2');
            $table->index(['cod_cco_no_final']);
            $table->index(['cod_cco_final']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('costo_distribuido');
    }
}
