<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AvanceModulos extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('avance_modulos', function (Blueprint $table) {
            $table->increments('avm_pk_id');
            $table->integer('con_fk_id');
            $table->string('ins_fk_id', 50);
            $table->integer('avm_ano')->nullable();
            $table->integer('avm_mes')->nullable();
            $table->boolean('avm_cut')->default(false);
            $table->boolean('avm_scu')->default(false);
            $table->boolean('avm_cco')->default(false);
            $table->boolean('avm_det_elementos')->default(false);
            $table->boolean('avm_cuentas')->default(false);
            $table->boolean('avm_actividades')->default(false);
            $table->boolean('avm_rel_actividades')->default(false);
            $table->boolean('avm_bases_distribucion')->default(false);
            $table->boolean('avm_dist_costos')->default(false);
            $table->boolean('avm_contratos')->default(false);
            $table->boolean('avm_gr_suministros')->default(false);
            $table->boolean('avm_rel_cuc')->default(false);
            $table->boolean('avm_suministros')->default(false);
            $table->boolean('avm_mano_obra')->default(false);
            $table->boolean('avm_rec_actividad')->default(false);
            $table->boolean('avm_inf_financiera')->default(false);
            $table->boolean('avm_inf_bd')->default(false);
            $table->boolean('avm_inf_produccion')->default(false);
            $table->boolean('avm_rec_cco')->default(false);
            $table->boolean('avm_dist_cp')->default(false);
            $table->boolean('avm_info_mano_obra')->default(false);
            $table->boolean('avm_det_sum')->default(false);

            $table->foreign('con_fk_id')->references('con_pk_id')->on('contrato')->onDelete('cascade');
            $table->foreign(['ins_fk_id', 'con_fk_id'])->references(['ins_pk_id', 'con_fk_id'])->on('instituciones')->onDelete('cascade');

            $table->unique(['con_fk_id', 'ins_fk_id', 'avm_ano', 'avm_mes']);

            $table->index(['con_fk_id', 'ins_fk_id', 'avm_ano', 'avm_mes']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('avance_modulos');
    }
}
