<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class TasaRecursosIndirectos extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tasa_recursos_indirectos', function (Blueprint $table) {
            $table->increments('tri_pk_id');
            $table->integer('con_fk_id');
            $table->string('ins_fk_id', 50);
            $table->integer('tri_ano');
            $table->integer('tri_mes');
            $table->integer('cco_fk_id');
            $table->float('tri_tasa_suministros');
            $table->float('tri_tasa_mano_obra');
            $table->float('tri_tasa_gastos_gen');
            $table->float('tri_tasa_costo');
            $table->float('tri_mano_obra_directa');
            $table->float('tri_mano_obra_indirecta');
            $table->float('tri_sumin_directos');
            $table->float('tri_sumin_indirectos');
            $table->float('tri_gast_generales');
            $table->float('tri_costo_dist');

            $table->foreign('con_fk_id')->references('con_pk_id')->on('contrato')->onDelete('cascade');
            $table->foreign(['ins_fk_id', 'con_fk_id'])->references(['ins_pk_id', 'con_fk_id'])->on('instituciones')->onDelete('cascade');
            $table->foreign('cco_fk_id')->references('cco_pk_id')->on('centros_costo')->onDelete('cascade');

            $table->unique(['con_fk_id', 'ins_fk_id', 'tri_ano', 'tri_mes', 'cco_fk_id']);

            $table->index(['con_fk_id', 'ins_fk_id', 'tri_ano', 'tri_mes'], 'tri_index1');
            $table->index(['con_fk_id', 'ins_fk_id', 'tri_ano', 'tri_mes', 'cco_fk_id'], 'tri_index2');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tasa_recursos_indirectos');
    }
}
