<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class DetalleSuministros extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('detalle_suministros', function (Blueprint $table) {
            $table->increments('des_pk_id');
            $table->integer('con_fk_id');
            $table->string('ins_fk_id', 50);
            $table->integer('des_ano');
            $table->integer('des_mes');
            $table->integer('cco_fk_id');
            $table->integer('sum_fk_id');
            $table->float('des_cantidad');
            $table->float('des_valor_unitario');

            $table->foreign('con_fk_id')->references('con_pk_id')->on('contrato')->onDelete('cascade');
            $table->foreign(['ins_fk_id', 'con_fk_id'])->references(['ins_pk_id', 'con_fk_id'])->on('instituciones')->onDelete('cascade');
            $table->foreign('cco_fk_id')->references('cco_pk_id')->on('centros_costo')->onDelete('cascade');
            $table->foreign('sum_fk_id')->references('sum_pk_id')->on('suministros')->onDelete('cascade');

            $table->unique(['con_fk_id', 'ins_fk_id', 'des_ano', 'des_mes', 'cco_fk_id', 'sum_fk_id']);

            $table->index(['con_fk_id', 'ins_fk_id', 'des_ano', 'des_mes'], 'des_index1');
            $table->index(['con_fk_id', 'ins_fk_id', 'des_ano', 'des_mes', 'cco_fk_id'], 'des_index2');
            $table->index(['con_fk_id', 'ins_fk_id', 'des_ano', 'des_mes', 'cco_fk_id', 'sum_fk_id'], 'des_index3');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('detalle_suministros');
    }
}
