<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CostoPrgActividades extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('costo_prg_actividades', function (Blueprint $table) {
            $table->bigIncrements('cpa_pk_id');

            $table->integer('con_fk_id');
            $table->string('ins_fk_id', 50);
            $table->integer('cpa_ano');
            $table->integer('cpa_mes');

            $table->integer('prg_fk_id');
            $table->integer('coe_fk_id');
            $table->integer('sed_fk_id');
            $table->integer('esp_fk_id');

            $table->integer('cco_fk_id');
            $table->integer('act_fk_id');

            $table->float('cpa_costo_mob_dir_actividad')->nullable();
            $table->float('cpa_costo_mob_indir_actividad')->nullable();
            $table->float('cpa_costo_sum_dir_actividad')->nullable();
            $table->float('cpa_costo_sum_indir_actividad')->nullable();
            $table->float('cpa_costo_ggen_actividad')->nullable();
            $table->float('cpa_costo_cdist_actividad')->nullable();
            $table->float('cpa_costo_actividad')->nullable();

            $table->index(['con_fk_id', 'ins_fk_id', 'cpa_ano', 'cpa_mes', 'prg_fk_id', 'act_fk_id'], 'c_prg_a_index1');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('costo_prg_actividades');
    }
}
