<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CostoEsperadoProgramas extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('costo_esperado_programas', function (Blueprint $table) {
            $table->bigIncrements('cpg_pk_id');

            $table->integer('con_fk_id');
            $table->string('ins_fk_id', 50);
            $table->integer('cpg_ano');
            $table->integer('cpg_mes');

            $table->integer('prg_fk_id');
            $table->integer('coe_fk_id');
            $table->integer('sed_fk_id');
            $table->integer('esp_fk_id');

            $table->integer('cpg_poblacion')->nullable();

            $table->float('cpg_mob_dir_costo')->nullable();
            $table->float('cpg_mob_indir_costo')->nullable();
            $table->float('cpg_sum_dir_costo')->nullable();
            $table->float('cpg_sum_indir_costo')->nullable();
            $table->float('cpg_gastos_gen_costo')->nullable();
            $table->float('cpg_costo_dist_costo')->nullable();
            $table->float('cpg_costo_programa')->nullable();
            $table->float('cpg_ventas')->nullable();
            $table->float('cpg_resultado')->nullable();
            $table->float('cpg_margen')->nullable();

            $table->index(['con_fk_id', 'ins_fk_id', 'cpg_ano', 'cpg_mes', 'prg_fk_id'], 'c_programa_index1');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('costo_esperado_programas');
    }
}
