<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CostoPrgEjPaquetes extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('costo_prg_ej_paquetes', function (Blueprint $table) {
            $table->bigIncrements('cep_pk_id');

            $table->integer('con_fk_id');
            $table->string('ins_fk_id', 50);
            $table->integer('cep_ano');
            $table->integer('cep_mes');

            $table->integer('prg_fk_id');
            $table->integer('coe_fk_id');
            $table->integer('sed_fk_id');
            $table->integer('esp_fk_id');

            $table->integer('cco_fk_id');
            $table->integer('act_fk_id');

            $table->float('cep_mob_dir_costo')->nullable();
            $table->float('cep_mob_indir_costo')->nullable();
            $table->float('cep_sum_dir_costo')->nullable();
            $table->float('cep_sum_indir_costo')->nullable();
            $table->float('cep_gastos_gen_costo')->nullable();
            $table->float('cep_costo_dist_costo')->nullable();
            $table->float('cep_costo_actividad')->nullable();

            $table->index(['con_fk_id', 'ins_fk_id', 'cep_ano', 'cep_mes', 'prg_fk_id', 'act_fk_id'], 'c_prg_eje_paquetes_index1');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('costo_prg_ej_paquetes');
    }
}
