<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CostoPrgEjSuministros extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('costo_prg_ej_suministros', function (Blueprint $table) {
            $table->bigIncrements('ces_pk_id');

            $table->integer('con_fk_id');
            $table->string('ins_fk_id', 50);
            $table->integer('ces_ano');
            $table->integer('ces_mes');

            $table->integer('prg_fk_id');
            $table->integer('coe_fk_id');
            $table->integer('sed_fk_id');
            $table->integer('esp_fk_id');

            $table->integer('cco_fk_id');
            $table->integer('sum_fk_id');

            $table->float('ces_costo_suministro')->nullable();

            $table->index(['con_fk_id', 'ins_fk_id', 'ces_ano', 'ces_mes', 'prg_fk_id', 'sum_fk_id'], 'c_prg_eje_suministros_index1');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('costo_prg_ej_suministros');
    }
}
