<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class SedesReps extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sedes_reps', function (Blueprint $table) {
            $table->increments('ser_pk_id');
            $table->string('inr_fk_id', 50);
            $table->string('ser_nombre_sede', 200);
            $table->string('ser_direccion', 300)->nullable();
            $table->boolean('ser_sede_activa')->default(true);

            // Llaves foraneas
            $table->foreign('inr_fk_id')->references('inr_pk_id')->on('instituciones_reps')->onDelete('cascade');

            $table->index('inr_fk_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sedes_reps');
    }
}
