<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class Instituciones extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('instituciones', function (Blueprint $table) {
            $table->string('ins_pk_id', 50);
            $table->integer('con_fk_id');
            $table->string('ins_nit', 50);
            $table->string('ins_razon_social', 200);
            $table->string('ins_rep_legal', 200)->nullable();
            $table->integer('dep_fk_id');
            $table->integer('mun_fk_id');
            $table->string('ins_direccion', 200)->nullable();

            // Llaves foraneas
            $table->primary(['ins_pk_id', 'con_fk_id']);
            $table->foreign('con_fk_id')->references('con_pk_id')->on('contrato')->onDelete('cascade');
            $table->foreign('dep_fk_id')->references('dep_pk_id')->on('departamentos')->onDelete('cascade');
            $table->foreign('mun_fk_id')->references('mun_pk_id')->on('municipios')->onDelete('cascade');

            $table->unique(['ins_pk_id', 'con_fk_id']);
            $table->index(['ins_pk_id', 'con_fk_id']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('instituciones');
    }
}
