<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class Actividades extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('actividades', function (Blueprint $table) {
            $table->increments('act_pk_id');
            $table->integer('con_fk_id');
            $table->string('ins_fk_id', 50);
            $table->integer('act_ano');
            $table->string('act_codigo', 25);
            $table->string('act_descripcion', 500);
            $table->boolean('act_paquete')->default(false);
            $table->string('act_desc_actividades', 2000)->nullable();
            $table->boolean('act_activo')->default(true);
            $table->date('act_fecha_inac')->nullable();

            $table->foreign('con_fk_id')->references('con_pk_id')->on('contrato')->onDelete('cascade');
            $table->foreign(['ins_fk_id', 'con_fk_id'])->references(['ins_pk_id', 'con_fk_id'])->on('instituciones')->onDelete('cascade');

            $table->unique(['con_fk_id', 'ins_fk_id', 'act_ano', 'act_codigo']);
            $table->index(['con_fk_id', 'ins_fk_id', 'act_ano']);
            $table->index(['con_fk_id', 'ins_fk_id', 'act_ano', 'act_codigo']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('actividades');
    }
}
