<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class GrupoSuministros extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('grupo_suministros', function (Blueprint $table) {
            $table->increments('grs_pk_id');
            $table->integer('con_fk_id');
            $table->string('ins_fk_id', 50);
            $table->integer('grs_ano');
            $table->string('grs_codigo', 10);
            $table->string('grs_nombre', 80);
            $table->boolean('grs_activo')->default(true);
            $table->date('grs_fecha_inac')->nullable();

            $table->foreign('con_fk_id')->references('con_pk_id')->on('contrato')->onDelete('cascade');
            $table->foreign(['ins_fk_id', 'con_fk_id'])->references(['ins_pk_id', 'con_fk_id'])->on('instituciones')->onDelete('cascade');

            $table->unique(['con_fk_id', 'ins_fk_id', 'grs_ano', 'grs_codigo']);
            $table->index(['con_fk_id', 'ins_fk_id', 'grs_ano']);
            $table->index(['con_fk_id', 'ins_fk_id', 'grs_ano', 'grs_codigo']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('grupo_suministros');
    }
}
