<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class RecActividadSuministros extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('rec_actividad_suministros', function (Blueprint $table) {
            $table->increments('ras_pk_id');
            $table->integer('con_fk_id');
            $table->string('ins_fk_id', 50);
            $table->integer('ras_ano');
            $table->integer('cco_fk_id');
            $table->integer('act_fk_id');
            $table->integer('sum_fk_id');
            $table->string('ras_unidad_medida', 80);
            $table->string('ras_unidad_consumo', 80);
            $table->float('ras_relacion');
            $table->float('ras_factor_conversion');
            $table->float('ras_consumo_actividad');

            $table->foreign('con_fk_id')->references('con_pk_id')->on('contrato')->onDelete('cascade');
            $table->foreign(['ins_fk_id', 'con_fk_id'])->references(['ins_pk_id', 'con_fk_id'])->on('instituciones')->onDelete('cascade');
            $table->foreign('cco_fk_id')->references('cco_pk_id')->on('centros_costo')->onDelete('cascade');
            $table->foreign('act_fk_id')->references('act_pk_id')->on('actividades')->onDelete('cascade');
            $table->foreign('sum_fk_id')->references('sum_pk_id')->on('suministros')->onDelete('cascade');

            $table->index(['con_fk_id', 'ins_fk_id', 'ras_ano', 'cco_fk_id'], 'ras_index1');
            $table->index(['con_fk_id', 'ins_fk_id', 'ras_ano', 'cco_fk_id', 'act_fk_id'], 'ras_index2');
            $table->index(['con_fk_id', 'ins_fk_id', 'ras_ano', 'cco_fk_id', 'act_fk_id', 'sum_fk_id'], 'ras_index3');

            $table->unique(['con_fk_id', 'ins_fk_id', 'ras_ano', 'cco_fk_id', 'act_fk_id', 'sum_fk_id']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('rec_actividad_suministros');
    }
}
